// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.model



/**
 * A complex type for the endpoint group for a custom routing accelerator. An Amazon Web Services Region can have only one endpoint group for a specific listener.
 */
public class CustomRoutingEndpointGroup private constructor(builder: Builder) {
    /**
     * For a custom routing accelerator, describes the port range and protocol for all endpoints (virtual private cloud subnets) in an endpoint group to accept client traffic on.
     */
    public val destinationDescriptions: List<CustomRoutingDestinationDescription>? = builder.destinationDescriptions
    /**
     * For a custom routing accelerator, describes the endpoints (virtual private cloud subnets) in an endpoint group to accept client traffic on.
     */
    public val endpointDescriptions: List<CustomRoutingEndpointDescription>? = builder.endpointDescriptions
    /**
     * The Amazon Resource Name (ARN) of the endpoint group.
     */
    public val endpointGroupArn: kotlin.String? = builder.endpointGroupArn
    /**
     * The Amazon Web Services Region where the endpoint group is located.
     */
    public val endpointGroupRegion: kotlin.String? = builder.endpointGroupRegion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.globalaccelerator.model.CustomRoutingEndpointGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CustomRoutingEndpointGroup(")
        append("destinationDescriptions=$destinationDescriptions,")
        append("endpointDescriptions=$endpointDescriptions,")
        append("endpointGroupArn=$endpointGroupArn,")
        append("endpointGroupRegion=$endpointGroupRegion)")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationDescriptions?.hashCode() ?: 0
        result = 31 * result + (endpointDescriptions?.hashCode() ?: 0)
        result = 31 * result + (endpointGroupArn?.hashCode() ?: 0)
        result = 31 * result + (endpointGroupRegion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CustomRoutingEndpointGroup

        if (destinationDescriptions != other.destinationDescriptions) return false
        if (endpointDescriptions != other.endpointDescriptions) return false
        if (endpointGroupArn != other.endpointGroupArn) return false
        if (endpointGroupRegion != other.endpointGroupRegion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.globalaccelerator.model.CustomRoutingEndpointGroup = Builder(this).apply(block).build()

    public class Builder {
        /**
         * For a custom routing accelerator, describes the port range and protocol for all endpoints (virtual private cloud subnets) in an endpoint group to accept client traffic on.
         */
        public var destinationDescriptions: List<CustomRoutingDestinationDescription>? = null
        /**
         * For a custom routing accelerator, describes the endpoints (virtual private cloud subnets) in an endpoint group to accept client traffic on.
         */
        public var endpointDescriptions: List<CustomRoutingEndpointDescription>? = null
        /**
         * The Amazon Resource Name (ARN) of the endpoint group.
         */
        public var endpointGroupArn: kotlin.String? = null
        /**
         * The Amazon Web Services Region where the endpoint group is located.
         */
        public var endpointGroupRegion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.globalaccelerator.model.CustomRoutingEndpointGroup) : this() {
            this.destinationDescriptions = x.destinationDescriptions
            this.endpointDescriptions = x.endpointDescriptions
            this.endpointGroupArn = x.endpointGroupArn
            this.endpointGroupRegion = x.endpointGroupRegion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.globalaccelerator.model.CustomRoutingEndpointGroup = CustomRoutingEndpointGroup(this)
    }
}
