// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.model



public class CreateAcceleratorRequest private constructor(builder: Builder) {
    /**
     * Indicates whether an accelerator is enabled. The value is true or false. The default value is true.
     *
     * If the value is set to true, an accelerator cannot be deleted. If set to false, the accelerator can be deleted.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of an accelerator.
     */
    public val idempotencyToken: kotlin.String? = builder.idempotencyToken
    /**
     * The IP address type that an accelerator supports. For a standard accelerator, the value can be IPV4 or DUAL_STACK.
     */
    public val ipAddressType: aws.sdk.kotlin.services.globalaccelerator.model.IpAddressType? = builder.ipAddressType
    /**
     * Optionally, if you've added your own IP address pool to Global Accelerator (BYOIP), you can choose an IPv4 address from your own pool to use for the accelerator's static IPv4 address when you create an accelerator.
     *
     * After you bring an address range to Amazon Web Services, it appears in your account as an address pool. When you create an accelerator, you can assign one IPv4 address from your range to it. Global Accelerator assigns you a second static IPv4 address from an Amazon IP address range. If you bring two IPv4 address ranges to Amazon Web Services, you can assign one IPv4 address from each range to your accelerator. This restriction is because Global Accelerator assigns each address range to a different network zone, for high availability.
     *
     * You can specify one or two addresses, separated by a space. Do not include the /32 suffix.
     *
     * Note that you can't update IP addresses for an existing accelerator. To change them, you must create a new accelerator with the new addresses.
     *
     * For more information, see [Bring your own IP addresses (BYOIP)](https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html) in the *Global Accelerator Developer Guide*.
     */
    public val ipAddresses: List<String>? = builder.ipAddresses
    /**
     * The name of the accelerator. The name can have a maximum of 64 characters, must contain only alphanumeric characters, periods (.), or hyphens (-), and must not begin or end with a hyphen or period.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Create tags for an accelerator.
     *
     * For more information, see [Tagging in Global Accelerator](https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html) in the *Global Accelerator Developer Guide*.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.globalaccelerator.model.CreateAcceleratorRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAcceleratorRequest(")
        append("enabled=$enabled,")
        append("idempotencyToken=$idempotencyToken,")
        append("ipAddressType=$ipAddressType,")
        append("ipAddresses=$ipAddresses,")
        append("name=$name,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled?.hashCode() ?: 0
        result = 31 * result + (idempotencyToken?.hashCode() ?: 0)
        result = 31 * result + (ipAddressType?.hashCode() ?: 0)
        result = 31 * result + (ipAddresses?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAcceleratorRequest

        if (enabled != other.enabled) return false
        if (idempotencyToken != other.idempotencyToken) return false
        if (ipAddressType != other.ipAddressType) return false
        if (ipAddresses != other.ipAddresses) return false
        if (name != other.name) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.globalaccelerator.model.CreateAcceleratorRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether an accelerator is enabled. The value is true or false. The default value is true.
         *
         * If the value is set to true, an accelerator cannot be deleted. If set to false, the accelerator can be deleted.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of an accelerator.
         */
        public var idempotencyToken: kotlin.String? = null
        /**
         * The IP address type that an accelerator supports. For a standard accelerator, the value can be IPV4 or DUAL_STACK.
         */
        public var ipAddressType: aws.sdk.kotlin.services.globalaccelerator.model.IpAddressType? = null
        /**
         * Optionally, if you've added your own IP address pool to Global Accelerator (BYOIP), you can choose an IPv4 address from your own pool to use for the accelerator's static IPv4 address when you create an accelerator.
         *
         * After you bring an address range to Amazon Web Services, it appears in your account as an address pool. When you create an accelerator, you can assign one IPv4 address from your range to it. Global Accelerator assigns you a second static IPv4 address from an Amazon IP address range. If you bring two IPv4 address ranges to Amazon Web Services, you can assign one IPv4 address from each range to your accelerator. This restriction is because Global Accelerator assigns each address range to a different network zone, for high availability.
         *
         * You can specify one or two addresses, separated by a space. Do not include the /32 suffix.
         *
         * Note that you can't update IP addresses for an existing accelerator. To change them, you must create a new accelerator with the new addresses.
         *
         * For more information, see [Bring your own IP addresses (BYOIP)](https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html) in the *Global Accelerator Developer Guide*.
         */
        public var ipAddresses: List<String>? = null
        /**
         * The name of the accelerator. The name can have a maximum of 64 characters, must contain only alphanumeric characters, periods (.), or hyphens (-), and must not begin or end with a hyphen or period.
         */
        public var name: kotlin.String? = null
        /**
         * Create tags for an accelerator.
         *
         * For more information, see [Tagging in Global Accelerator](https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html) in the *Global Accelerator Developer Guide*.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.globalaccelerator.model.CreateAcceleratorRequest) : this() {
            this.enabled = x.enabled
            this.idempotencyToken = x.idempotencyToken
            this.ipAddressType = x.ipAddressType
            this.ipAddresses = x.ipAddresses
            this.name = x.name
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.globalaccelerator.model.CreateAcceleratorRequest = CreateAcceleratorRequest(this)
    }
}
