// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.glacier.serde

import aws.sdk.kotlin.services.glacier.model.UploadMultipartPartRequest
import aws.smithy.kotlin.runtime.content.ByteStream
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.toHttpBody
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UploadMultipartPartOperationSerializer: HttpSerializer.NonStreaming<UploadMultipartPartRequest> {
    override fun serialize(context: ExecutionContext, input: UploadMultipartPartRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.accountId) { "accountId is bound to the URI and must not be null" }
            requireNotNull(input.vaultName) { "vaultName is bound to the URI and must not be null" }
            requireNotNull(input.uploadId) { "uploadId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.SmithyLabel.encode(input.accountId))
                add(PercentEncoding.Path.encode("vaults"))
                add(PercentEncoding.SmithyLabel.encode(input.vaultName))
                add(PercentEncoding.Path.encode("multipart-uploads"))
                add(PercentEncoding.SmithyLabel.encode(input.uploadId))
            }
        }

        builder.headers {
            if (input.checksum != null) append("x-amz-sha256-tree-hash", input.checksum)
            if (input.range != null) append("Content-Range", input.range)
        }

        if (input.body != null) {
            builder.body = input.body.toHttpBody()
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        if (input.body == null) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        return builder
    }
}
