// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.glacier.serde

import aws.sdk.kotlin.services.glacier.model.SetVaultNotificationsRequest
import aws.sdk.kotlin.services.glacier.model.VaultNotificationConfig
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class SetVaultNotificationsOperationSerializer: HttpSerializer.NonStreaming<SetVaultNotificationsRequest> {
    override fun serialize(context: ExecutionContext, input: SetVaultNotificationsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.accountId) { "accountId is bound to the URI and must not be null" }
            requireNotNull(input.vaultName) { "vaultName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.SmithyLabel.encode(input.accountId))
                add(PercentEncoding.Path.encode("vaults"))
                add(PercentEncoding.SmithyLabel.encode(input.vaultName))
                add(PercentEncoding.Path.encode("notification-configuration"))
            }
        }

        if (input.vaultNotificationConfig != null) {
            val payload = serializeVaultNotificationConfigPayload(input.vaultNotificationConfig)
            builder.body = HttpBody.fromBytes(payload)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        if (input.vaultNotificationConfig == null) {
            builder.body = HttpBody.fromBytes("{}".encodeToByteArray())
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}
