// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.glacier.serde

import aws.sdk.kotlin.services.glacier.model.GlacierException
import aws.sdk.kotlin.services.glacier.model.SetDataRetrievalPolicyResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class SetDataRetrievalPolicyOperationDeserializer: HttpDeserializer.NonStreaming<SetDataRetrievalPolicyResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): SetDataRetrievalPolicyResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwSetDataRetrievalPolicyError(context, call, payload)
        }
        val builder = SetDataRetrievalPolicyResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwSetDataRetrievalPolicyError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw GlacierException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "MissingParameterValueException" -> MissingParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> GlacierException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
