// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.glacier.serde

import aws.sdk.kotlin.services.glacier.model.InitiateVaultLockRequest
import aws.sdk.kotlin.services.glacier.model.VaultLockPolicy
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class InitiateVaultLockOperationSerializer: HttpSerializer.NonStreaming<InitiateVaultLockRequest> {
    override fun serialize(context: ExecutionContext, input: InitiateVaultLockRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.accountId) { "accountId is bound to the URI and must not be null" }
            requireNotNull(input.vaultName) { "vaultName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.SmithyLabel.encode(input.accountId))
                add(PercentEncoding.Path.encode("vaults"))
                add(PercentEncoding.SmithyLabel.encode(input.vaultName))
                add(PercentEncoding.Path.encode("lock-policy"))
            }
        }

        if (input.policy != null) {
            val payload = serializeVaultLockPolicyPayload(input.policy)
            builder.body = HttpBody.fromBytes(payload)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        if (input.policy == null) {
            builder.body = HttpBody.fromBytes("{}".encodeToByteArray())
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}
