// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.glacier.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.content.ByteStream

/**
 * Provides options to add an archive to a vault.
 */
public class UploadArchiveRequest private constructor(builder: Builder) {
    /**
     * The `AccountId` value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens ('-') in the ID.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The optional description of the archive you are uploading.
     */
    public val archiveDescription: kotlin.String? = builder.archiveDescription
    /**
     * The data to upload.
     */
    public val body: aws.smithy.kotlin.runtime.content.ByteStream? = builder.body
    /**
     * The SHA256 tree hash of the data being uploaded.
     */
    public val checksum: kotlin.String? = builder.checksum
    /**
     * The name of the vault.
     */
    public val vaultName: kotlin.String? = builder.vaultName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.glacier.model.UploadArchiveRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UploadArchiveRequest(")
        append("accountId=$accountId,")
        append("archiveDescription=$archiveDescription,")
        append("body=$body,")
        append("checksum=$checksum,")
        append("vaultName=$vaultName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (archiveDescription?.hashCode() ?: 0)
        result = 31 * result + (body?.hashCode() ?: 0)
        result = 31 * result + (checksum?.hashCode() ?: 0)
        result = 31 * result + (vaultName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UploadArchiveRequest

        if (accountId != other.accountId) return false
        if (archiveDescription != other.archiveDescription) return false
        if (body != other.body) return false
        if (checksum != other.checksum) return false
        if (vaultName != other.vaultName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.glacier.model.UploadArchiveRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The `AccountId` value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens ('-') in the ID.
         */
        public var accountId: kotlin.String? = null
        /**
         * The optional description of the archive you are uploading.
         */
        public var archiveDescription: kotlin.String? = null
        /**
         * The data to upload.
         */
        public var body: aws.smithy.kotlin.runtime.content.ByteStream? = null
        /**
         * The SHA256 tree hash of the data being uploaded.
         */
        public var checksum: kotlin.String? = null
        /**
         * The name of the vault.
         */
        public var vaultName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.glacier.model.UploadArchiveRequest) : this() {
            this.accountId = x.accountId
            this.archiveDescription = x.archiveDescription
            this.body = x.body
            this.checksum = x.checksum
            this.vaultName = x.vaultName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.glacier.model.UploadArchiveRequest = UploadArchiveRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
