// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.glacier.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides options for initiating a multipart upload to an Amazon S3 Glacier vault.
 */
public class InitiateMultipartUploadRequest private constructor(builder: Builder) {
    /**
     * The `AccountId` value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens ('-') in the ID.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The archive description that you are uploading in parts.
     *
     * The part size must be a megabyte (1024 KB) multiplied by a power of 2, for example 1048576 (1 MB), 2097152 (2 MB), 4194304 (4 MB), 8388608 (8 MB), and so on. The minimum allowable part size is 1 MB, and the maximum is 4 GB (4096 MB).
     */
    public val archiveDescription: kotlin.String? = builder.archiveDescription
    /**
     * The size of each part except the last, in bytes. The last part can be smaller than this part size.
     */
    public val partSize: kotlin.String? = builder.partSize
    /**
     * The name of the vault.
     */
    public val vaultName: kotlin.String? = builder.vaultName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.glacier.model.InitiateMultipartUploadRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InitiateMultipartUploadRequest(")
        append("accountId=$accountId,")
        append("archiveDescription=$archiveDescription,")
        append("partSize=$partSize,")
        append("vaultName=$vaultName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (archiveDescription?.hashCode() ?: 0)
        result = 31 * result + (partSize?.hashCode() ?: 0)
        result = 31 * result + (vaultName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InitiateMultipartUploadRequest

        if (accountId != other.accountId) return false
        if (archiveDescription != other.archiveDescription) return false
        if (partSize != other.partSize) return false
        if (vaultName != other.vaultName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.glacier.model.InitiateMultipartUploadRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The `AccountId` value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens ('-') in the ID.
         */
        public var accountId: kotlin.String? = null
        /**
         * The archive description that you are uploading in parts.
         *
         * The part size must be a megabyte (1024 KB) multiplied by a power of 2, for example 1048576 (1 MB), 2097152 (2 MB), 4194304 (4 MB), 8388608 (8 MB), and so on. The minimum allowable part size is 1 MB, and the maximum is 4 GB (4096 MB).
         */
        public var archiveDescription: kotlin.String? = null
        /**
         * The size of each part except the last, in bytes. The last part can be smaller than this part size.
         */
        public var partSize: kotlin.String? = null
        /**
         * The name of the vault.
         */
        public var vaultName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.glacier.model.InitiateMultipartUploadRequest) : this() {
            this.accountId = x.accountId
            this.archiveDescription = x.archiveDescription
            this.partSize = x.partSize
            this.vaultName = x.vaultName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.glacier.model.InitiateMultipartUploadRequest = InitiateMultipartUploadRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
