// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.glacier.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides options to complete a multipart upload operation. This informs Amazon Glacier that all the archive parts have been uploaded and Amazon S3 Glacier (Glacier) can now assemble the archive from the uploaded parts. After assembling and saving the archive to the vault, Glacier returns the URI path of the newly created archive resource.
 */
public class CompleteMultipartUploadRequest private constructor(builder: Builder) {
    /**
     * The `AccountId` value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens ('-') in the ID.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The total size, in bytes, of the entire archive. This value should be the sum of all the sizes of the individual parts that you uploaded.
     */
    public val archiveSize: kotlin.String? = builder.archiveSize
    /**
     * The SHA256 tree hash of the entire archive. It is the tree hash of SHA256 tree hash of the individual parts. If the value you specify in the request does not match the SHA256 tree hash of the final assembled archive as computed by Amazon S3 Glacier (Glacier), Glacier returns an error and the request fails.
     */
    public val checksum: kotlin.String? = builder.checksum
    /**
     * The upload ID of the multipart upload.
     */
    public val uploadId: kotlin.String? = builder.uploadId
    /**
     * The name of the vault.
     */
    public val vaultName: kotlin.String? = builder.vaultName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.glacier.model.CompleteMultipartUploadRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CompleteMultipartUploadRequest(")
        append("accountId=$accountId,")
        append("archiveSize=$archiveSize,")
        append("checksum=$checksum,")
        append("uploadId=$uploadId,")
        append("vaultName=$vaultName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (archiveSize?.hashCode() ?: 0)
        result = 31 * result + (checksum?.hashCode() ?: 0)
        result = 31 * result + (uploadId?.hashCode() ?: 0)
        result = 31 * result + (vaultName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CompleteMultipartUploadRequest

        if (accountId != other.accountId) return false
        if (archiveSize != other.archiveSize) return false
        if (checksum != other.checksum) return false
        if (uploadId != other.uploadId) return false
        if (vaultName != other.vaultName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.glacier.model.CompleteMultipartUploadRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The `AccountId` value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens ('-') in the ID.
         */
        public var accountId: kotlin.String? = null
        /**
         * The total size, in bytes, of the entire archive. This value should be the sum of all the sizes of the individual parts that you uploaded.
         */
        public var archiveSize: kotlin.String? = null
        /**
         * The SHA256 tree hash of the entire archive. It is the tree hash of SHA256 tree hash of the individual parts. If the value you specify in the request does not match the SHA256 tree hash of the final assembled archive as computed by Amazon S3 Glacier (Glacier), Glacier returns an error and the request fails.
         */
        public var checksum: kotlin.String? = null
        /**
         * The upload ID of the multipart upload.
         */
        public var uploadId: kotlin.String? = null
        /**
         * The name of the vault.
         */
        public var vaultName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.glacier.model.CompleteMultipartUploadRequest) : this() {
            this.accountId = x.accountId
            this.archiveSize = x.archiveSize
            this.checksum = x.checksum
            this.uploadId = x.uploadId
            this.vaultName = x.vaultName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.glacier.model.CompleteMultipartUploadRequest = CompleteMultipartUploadRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
