// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.glacier.serde

import aws.sdk.kotlin.services.glacier.model.SetVaultAccessPolicyRequest
import aws.sdk.kotlin.services.glacier.model.VaultAccessPolicy
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class SetVaultAccessPolicyOperationSerializer: HttpSerializer.NonStreaming<SetVaultAccessPolicyRequest> {
    override fun serialize(context: ExecutionContext, input: SetVaultAccessPolicyRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.accountId) { "accountId is bound to the URI and must not be null" }
            requireNotNull(input.vaultName) { "vaultName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.SmithyLabel.encode(input.accountId))
                add(PercentEncoding.Path.encode("vaults"))
                add(PercentEncoding.SmithyLabel.encode(input.vaultName))
                add(PercentEncoding.Path.encode("access-policy"))
            }
        }

        if (input.policy != null) {
            val payload = serializeVaultAccessPolicyPayload(input.policy)
            builder.body = HttpBody.fromBytes(payload)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        if (input.policy == null) {
            builder.body = HttpBody.fromBytes("{}".encodeToByteArray())
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}
