// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.glacier.serde

import aws.sdk.kotlin.services.glacier.model.GlacierException
import aws.sdk.kotlin.services.glacier.model.InitiateMultipartUploadResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class InitiateMultipartUploadOperationDeserializer: HttpDeserializer.NonStreaming<InitiateMultipartUploadResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): InitiateMultipartUploadResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwInitiateMultipartUploadError(context, call, payload)
        }
        val builder = InitiateMultipartUploadResponse.Builder()

        builder.location = response.headers["Location"]
        builder.uploadId = response.headers["x-amz-multipart-upload-id"]

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwInitiateMultipartUploadError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw GlacierException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "MissingParameterValueException" -> MissingParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> GlacierException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
