// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.glacier.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides options for specifying a range inventory retrieval job.
 */
public class InventoryRetrievalJobInput private constructor(builder: Builder) {
    /**
     * The end of the date range in UTC for vault inventory retrieval that includes archives created before this date. This value should be a string in the ISO 8601 date format, for example `2013-03-20T17:03:43Z`.
     */
    public val endDate: kotlin.String? = builder.endDate
    /**
     * Specifies the maximum number of inventory items returned per vault inventory retrieval request. Valid values are greater than or equal to 1.
     */
    public val limit: kotlin.String? = builder.limit
    /**
     * An opaque string that represents where to continue pagination of the vault inventory retrieval results. You use the marker in a new **InitiateJob** request to obtain additional inventory items. If there are no more inventory items, this value is `null`.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The start of the date range in UTC for vault inventory retrieval that includes archives created on or after this date. This value should be a string in the ISO 8601 date format, for example `2013-03-20T17:03:43Z`.
     */
    public val startDate: kotlin.String? = builder.startDate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.glacier.model.InventoryRetrievalJobInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InventoryRetrievalJobInput(")
        append("endDate=$endDate,")
        append("limit=$limit,")
        append("marker=$marker,")
        append("startDate=$startDate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endDate?.hashCode() ?: 0
        result = 31 * result + (limit?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (startDate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InventoryRetrievalJobInput

        if (endDate != other.endDate) return false
        if (limit != other.limit) return false
        if (marker != other.marker) return false
        if (startDate != other.startDate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.glacier.model.InventoryRetrievalJobInput = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The end of the date range in UTC for vault inventory retrieval that includes archives created before this date. This value should be a string in the ISO 8601 date format, for example `2013-03-20T17:03:43Z`.
         */
        public var endDate: kotlin.String? = null
        /**
         * Specifies the maximum number of inventory items returned per vault inventory retrieval request. Valid values are greater than or equal to 1.
         */
        public var limit: kotlin.String? = null
        /**
         * An opaque string that represents where to continue pagination of the vault inventory retrieval results. You use the marker in a new **InitiateJob** request to obtain additional inventory items. If there are no more inventory items, this value is `null`.
         */
        public var marker: kotlin.String? = null
        /**
         * The start of the date range in UTC for vault inventory retrieval that includes archives created on or after this date. This value should be a string in the ISO 8601 date format, for example `2013-03-20T17:03:43Z`.
         */
        public var startDate: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.glacier.model.InventoryRetrievalJobInput) : this() {
            this.endDate = x.endDate
            this.limit = x.limit
            this.marker = x.marker
            this.startDate = x.startDate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.glacier.model.InventoryRetrievalJobInput = InventoryRetrievalJobInput(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
