// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.glacier.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.content.ByteStream

/**
 * Contains the Amazon S3 Glacier response to your request.
 */
public class GetJobOutputResponse private constructor(builder: Builder) {
    /**
     * Indicates the range units accepted. For more information, see [RFC2616](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html).
     */
    public val acceptRanges: kotlin.String? = builder.acceptRanges
    /**
     * The description of an archive.
     */
    public val archiveDescription: kotlin.String? = builder.archiveDescription
    /**
     * The job data, either archive data or inventory data.
     */
    public val body: aws.smithy.kotlin.runtime.content.ByteStream? = builder.body
    /**
     * The checksum of the data in the response. This header is returned only when retrieving the output for an archive retrieval job. Furthermore, this header appears only under the following conditions:
     * + You get the entire range of the archive.
     * + You request a range to return of the archive that starts and ends on a multiple of 1 MB. For example, if you have an 3.1 MB archive and you specify a range to return that starts at 1 MB and ends at 2 MB, then the x-amz-sha256-tree-hash is returned as a response header.
     * + You request a range of the archive to return that starts on a multiple of 1 MB and goes to the end of the archive. For example, if you have a 3.1 MB archive and you specify a range that starts at 2 MB and ends at 3.1 MB (the end of the archive), then the x-amz-sha256-tree-hash is returned as a response header.
     */
    public val checksum: kotlin.String? = builder.checksum
    /**
     * The range of bytes returned by Amazon S3 Glacier. If only partial output is downloaded, the response provides the range of bytes Amazon S3 Glacier returned. For example, bytes 0-1048575/8388608 returns the first 1 MB from 8 MB.
     */
    public val contentRange: kotlin.String? = builder.contentRange
    /**
     * The Content-Type depends on whether the job output is an archive or a vault inventory. For archive data, the Content-Type is application/octet-stream. For vault inventory, if you requested CSV format when you initiated the job, the Content-Type is text/csv. Otherwise, by default, vault inventory is returned as JSON, and the Content-Type is application/json.
     */
    public val contentType: kotlin.String? = builder.contentType
    /**
     * The HTTP response code for a job output request. The value depends on whether a range was specified in the request.
     */
    public val status: kotlin.Int = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.glacier.model.GetJobOutputResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetJobOutputResponse(")
        append("acceptRanges=$acceptRanges,")
        append("archiveDescription=$archiveDescription,")
        append("body=$body,")
        append("checksum=$checksum,")
        append("contentRange=$contentRange,")
        append("contentType=$contentType,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceptRanges?.hashCode() ?: 0
        result = 31 * result + (archiveDescription?.hashCode() ?: 0)
        result = 31 * result + (body?.hashCode() ?: 0)
        result = 31 * result + (checksum?.hashCode() ?: 0)
        result = 31 * result + (contentRange?.hashCode() ?: 0)
        result = 31 * result + (contentType?.hashCode() ?: 0)
        result = 31 * result + (status)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetJobOutputResponse

        if (acceptRanges != other.acceptRanges) return false
        if (archiveDescription != other.archiveDescription) return false
        if (body != other.body) return false
        if (checksum != other.checksum) return false
        if (contentRange != other.contentRange) return false
        if (contentType != other.contentType) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.glacier.model.GetJobOutputResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates the range units accepted. For more information, see [RFC2616](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html).
         */
        public var acceptRanges: kotlin.String? = null
        /**
         * The description of an archive.
         */
        public var archiveDescription: kotlin.String? = null
        /**
         * The job data, either archive data or inventory data.
         */
        public var body: aws.smithy.kotlin.runtime.content.ByteStream? = null
        /**
         * The checksum of the data in the response. This header is returned only when retrieving the output for an archive retrieval job. Furthermore, this header appears only under the following conditions:
         * + You get the entire range of the archive.
         * + You request a range to return of the archive that starts and ends on a multiple of 1 MB. For example, if you have an 3.1 MB archive and you specify a range to return that starts at 1 MB and ends at 2 MB, then the x-amz-sha256-tree-hash is returned as a response header.
         * + You request a range of the archive to return that starts on a multiple of 1 MB and goes to the end of the archive. For example, if you have a 3.1 MB archive and you specify a range that starts at 2 MB and ends at 3.1 MB (the end of the archive), then the x-amz-sha256-tree-hash is returned as a response header.
         */
        public var checksum: kotlin.String? = null
        /**
         * The range of bytes returned by Amazon S3 Glacier. If only partial output is downloaded, the response provides the range of bytes Amazon S3 Glacier returned. For example, bytes 0-1048575/8388608 returns the first 1 MB from 8 MB.
         */
        public var contentRange: kotlin.String? = null
        /**
         * The Content-Type depends on whether the job output is an archive or a vault inventory. For archive data, the Content-Type is application/octet-stream. For vault inventory, if you requested CSV format when you initiated the job, the Content-Type is text/csv. Otherwise, by default, vault inventory is returned as JSON, and the Content-Type is application/json.
         */
        public var contentType: kotlin.String? = null
        /**
         * The HTTP response code for a job output request. The value depends on whether a range was specified in the request.
         */
        public var status: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.glacier.model.GetJobOutputResponse) : this() {
            this.acceptRanges = x.acceptRanges
            this.archiveDescription = x.archiveDescription
            this.body = x.body
            this.checksum = x.checksum
            this.contentRange = x.contentRange
            this.contentType = x.contentType
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.glacier.model.GetJobOutputResponse = GetJobOutputResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
