// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.glacier.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides options for downloading output of an Amazon S3 Glacier job.
 */
public class GetJobOutputRequest private constructor(builder: Builder) {
    /**
     * The `AccountId` value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens ('-') in the ID.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The job ID whose data is downloaded.
     */
    public val jobId: kotlin.String? = builder.jobId
    /**
     * The range of bytes to retrieve from the output. For example, if you want to download the first 1,048,576 bytes, specify the range as `bytes=0-1048575`. By default, this operation downloads the entire output.
     *
     * If the job output is large, then you can use a range to retrieve a portion of the output. This allows you to download the entire output in smaller chunks of bytes. For example, suppose you have 1 GB of job output you want to download and you decide to download 128 MB chunks of data at a time, which is a total of eight Get Job Output requests. You use the following process to download the job output:
     * + Download a 128 MB chunk of output by specifying the appropriate byte range. Verify that all 128 MB of data was received.
     * + Along with the data, the response includes a SHA256 tree hash of the payload. You compute the checksum of the payload on the client and compare it with the checksum you received in the response to ensure you received all the expected data.
     * + Repeat steps 1 and 2 for all the eight 128 MB chunks of output data, each time specifying the appropriate byte range.
     * + After downloading all the parts of the job output, you have a list of eight checksum values. Compute the tree hash of these values to find the checksum of the entire output. Using the DescribeJob API, obtain job information of the job that provided you the output. The response includes the checksum of the entire archive stored in Amazon S3 Glacier. You compare this value with the checksum you computed to ensure you have downloaded the entire archive content with no errors.
     */
    public val range: kotlin.String? = builder.range
    /**
     * The name of the vault.
     */
    public val vaultName: kotlin.String? = builder.vaultName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.glacier.model.GetJobOutputRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetJobOutputRequest(")
        append("accountId=$accountId,")
        append("jobId=$jobId,")
        append("range=$range,")
        append("vaultName=$vaultName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (range?.hashCode() ?: 0)
        result = 31 * result + (vaultName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetJobOutputRequest

        if (accountId != other.accountId) return false
        if (jobId != other.jobId) return false
        if (range != other.range) return false
        if (vaultName != other.vaultName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.glacier.model.GetJobOutputRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The `AccountId` value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens ('-') in the ID.
         */
        public var accountId: kotlin.String? = null
        /**
         * The job ID whose data is downloaded.
         */
        public var jobId: kotlin.String? = null
        /**
         * The range of bytes to retrieve from the output. For example, if you want to download the first 1,048,576 bytes, specify the range as `bytes=0-1048575`. By default, this operation downloads the entire output.
         *
         * If the job output is large, then you can use a range to retrieve a portion of the output. This allows you to download the entire output in smaller chunks of bytes. For example, suppose you have 1 GB of job output you want to download and you decide to download 128 MB chunks of data at a time, which is a total of eight Get Job Output requests. You use the following process to download the job output:
         * + Download a 128 MB chunk of output by specifying the appropriate byte range. Verify that all 128 MB of data was received.
         * + Along with the data, the response includes a SHA256 tree hash of the payload. You compute the checksum of the payload on the client and compare it with the checksum you received in the response to ensure you received all the expected data.
         * + Repeat steps 1 and 2 for all the eight 128 MB chunks of output data, each time specifying the appropriate byte range.
         * + After downloading all the parts of the job output, you have a list of eight checksum values. Compute the tree hash of these values to find the checksum of the entire output. Using the DescribeJob API, obtain job information of the job that provided you the output. The response includes the checksum of the entire archive stored in Amazon S3 Glacier. You compare this value with the checksum you computed to ensure you have downloaded the entire archive content with no errors.
         */
        public var range: kotlin.String? = null
        /**
         * The name of the vault.
         */
        public var vaultName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.glacier.model.GetJobOutputRequest) : this() {
            this.accountId = x.accountId
            this.jobId = x.jobId
            this.range = x.range
            this.vaultName = x.vaultName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.glacier.model.GetJobOutputRequest = GetJobOutputRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
