// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.glacier.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The input values for `AddTagsToVault`.
 */
public class AddTagsToVaultRequest private constructor(builder: Builder) {
    /**
     * The `AccountId` value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens ('-') in the ID.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The tags to add to the vault. Each tag is composed of a key and a value. The value can be an empty string.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The name of the vault.
     */
    public val vaultName: kotlin.String? = builder.vaultName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.glacier.model.AddTagsToVaultRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AddTagsToVaultRequest(")
        append("accountId=$accountId,")
        append("tags=$tags,")
        append("vaultName=$vaultName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vaultName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AddTagsToVaultRequest

        if (accountId != other.accountId) return false
        if (tags != other.tags) return false
        if (vaultName != other.vaultName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.glacier.model.AddTagsToVaultRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The `AccountId` value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens ('-') in the ID.
         */
        public var accountId: kotlin.String? = null
        /**
         * The tags to add to the vault. Each tag is composed of a key and a value. The value can be an empty string.
         */
        public var tags: Map<String, String>? = null
        /**
         * The name of the vault.
         */
        public var vaultName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.glacier.model.AddTagsToVaultRequest) : this() {
            this.accountId = x.accountId
            this.tags = x.tags
            this.vaultName = x.vaultName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.glacier.model.AddTagsToVaultRequest = AddTagsToVaultRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
