// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamesparks.transform

import aws.sdk.kotlin.services.gamesparks.model.ExtensionVersionDetails
import aws.sdk.kotlin.services.gamesparks.model.GameSparksException
import aws.sdk.kotlin.services.gamesparks.model.GetExtensionVersionResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetExtensionVersionOperationDeserializer: HttpDeserialize<GetExtensionVersionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetExtensionVersionResponse {
        if (!response.status.isSuccess()) {
            throwGetExtensionVersionError(context, response)
        }
        val builder = GetExtensionVersionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetExtensionVersionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetExtensionVersionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw GameSparksException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> GameSparksException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetExtensionVersionOperationBody(builder: GetExtensionVersionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val EXTENSIONVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ExtensionVersion"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EXTENSIONVERSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                EXTENSIONVERSION_DESCRIPTOR.index -> builder.extensionVersion = deserializeExtensionVersionDetailsDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
