// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamesparks.paginators

import aws.sdk.kotlin.services.gamesparks.GameSparksClient
import aws.sdk.kotlin.services.gamesparks.model.ExtensionDetails
import aws.sdk.kotlin.services.gamesparks.model.ExtensionVersionDetails
import aws.sdk.kotlin.services.gamesparks.model.GameSummary
import aws.sdk.kotlin.services.gamesparks.model.GeneratedCodeJobDetails
import aws.sdk.kotlin.services.gamesparks.model.ListExtensionVersionsRequest
import aws.sdk.kotlin.services.gamesparks.model.ListExtensionVersionsResponse
import aws.sdk.kotlin.services.gamesparks.model.ListExtensionsRequest
import aws.sdk.kotlin.services.gamesparks.model.ListExtensionsResponse
import aws.sdk.kotlin.services.gamesparks.model.ListGamesRequest
import aws.sdk.kotlin.services.gamesparks.model.ListGamesResponse
import aws.sdk.kotlin.services.gamesparks.model.ListGeneratedCodeJobsRequest
import aws.sdk.kotlin.services.gamesparks.model.ListGeneratedCodeJobsResponse
import aws.sdk.kotlin.services.gamesparks.model.ListSnapshotsRequest
import aws.sdk.kotlin.services.gamesparks.model.ListSnapshotsResponse
import aws.sdk.kotlin.services.gamesparks.model.ListStageDeploymentsRequest
import aws.sdk.kotlin.services.gamesparks.model.ListStageDeploymentsResponse
import aws.sdk.kotlin.services.gamesparks.model.ListStagesRequest
import aws.sdk.kotlin.services.gamesparks.model.ListStagesResponse
import aws.sdk.kotlin.services.gamesparks.model.SnapshotSummary
import aws.sdk.kotlin.services.gamesparks.model.StageDeploymentSummary
import aws.sdk.kotlin.services.gamesparks.model.StageSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListExtensionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListExtensionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListExtensionsResponse]
 */
public fun GameSparksClient.listExtensionsPaginated(initialRequest: ListExtensionsRequest): Flow<ListExtensionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listExtensionsPaginated.listExtensions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListExtensionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListExtensionsResponse]
 */
public fun GameSparksClient.listExtensionsPaginated(block: ListExtensionsRequest.Builder.() -> Unit): Flow<ListExtensionsResponse> =
    listExtensionsPaginated(ListExtensionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listExtensionsPaginated]
 * to access the nested member [ExtensionDetails]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ExtensionDetails]
 */
@JvmName("listExtensionsResponseExtensionDetails")
public fun Flow<ListExtensionsResponse>.extensions(): Flow<ExtensionDetails> =
    transform() { response ->
        response.extensions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListExtensionVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListExtensionVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListExtensionVersionsResponse]
 */
public fun GameSparksClient.listExtensionVersionsPaginated(initialRequest: ListExtensionVersionsRequest): Flow<ListExtensionVersionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listExtensionVersionsPaginated.listExtensionVersions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListExtensionVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListExtensionVersionsResponse]
 */
public fun GameSparksClient.listExtensionVersionsPaginated(block: ListExtensionVersionsRequest.Builder.() -> Unit): Flow<ListExtensionVersionsResponse> =
    listExtensionVersionsPaginated(ListExtensionVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listExtensionVersionsPaginated]
 * to access the nested member [ExtensionVersionDetails]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ExtensionVersionDetails]
 */
@JvmName("listExtensionVersionsResponseExtensionVersionDetails")
public fun Flow<ListExtensionVersionsResponse>.extensionVersions(): Flow<ExtensionVersionDetails> =
    transform() { response ->
        response.extensionVersions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListGamesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGamesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGamesResponse]
 */
public fun GameSparksClient.listGamesPaginated(initialRequest: ListGamesRequest): Flow<ListGamesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listGamesPaginated.listGames(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListGamesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGamesResponse]
 */
public fun GameSparksClient.listGamesPaginated(block: ListGamesRequest.Builder.() -> Unit): Flow<ListGamesResponse> =
    listGamesPaginated(ListGamesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listGamesPaginated]
 * to access the nested member [GameSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GameSummary]
 */
@JvmName("listGamesResponseGameSummary")
public fun Flow<ListGamesResponse>.games(): Flow<GameSummary> =
    transform() { response ->
        response.games?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListGeneratedCodeJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGeneratedCodeJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGeneratedCodeJobsResponse]
 */
public fun GameSparksClient.listGeneratedCodeJobsPaginated(initialRequest: ListGeneratedCodeJobsRequest): Flow<ListGeneratedCodeJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listGeneratedCodeJobsPaginated.listGeneratedCodeJobs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListGeneratedCodeJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGeneratedCodeJobsResponse]
 */
public fun GameSparksClient.listGeneratedCodeJobsPaginated(block: ListGeneratedCodeJobsRequest.Builder.() -> Unit): Flow<ListGeneratedCodeJobsResponse> =
    listGeneratedCodeJobsPaginated(ListGeneratedCodeJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listGeneratedCodeJobsPaginated]
 * to access the nested member [GeneratedCodeJobDetails]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GeneratedCodeJobDetails]
 */
@JvmName("listGeneratedCodeJobsResponseGeneratedCodeJobDetails")
public fun Flow<ListGeneratedCodeJobsResponse>.generatedCodeJobs(): Flow<GeneratedCodeJobDetails> =
    transform() { response ->
        response.generatedCodeJobs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSnapshotsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSnapshotsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSnapshotsResponse]
 */
public fun GameSparksClient.listSnapshotsPaginated(initialRequest: ListSnapshotsRequest): Flow<ListSnapshotsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSnapshotsPaginated.listSnapshots(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListSnapshotsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSnapshotsResponse]
 */
public fun GameSparksClient.listSnapshotsPaginated(block: ListSnapshotsRequest.Builder.() -> Unit): Flow<ListSnapshotsResponse> =
    listSnapshotsPaginated(ListSnapshotsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSnapshotsPaginated]
 * to access the nested member [SnapshotSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SnapshotSummary]
 */
@JvmName("listSnapshotsResponseSnapshotSummary")
public fun Flow<ListSnapshotsResponse>.snapshots(): Flow<SnapshotSummary> =
    transform() { response ->
        response.snapshots?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListStageDeploymentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStageDeploymentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStageDeploymentsResponse]
 */
public fun GameSparksClient.listStageDeploymentsPaginated(initialRequest: ListStageDeploymentsRequest): Flow<ListStageDeploymentsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listStageDeploymentsPaginated.listStageDeployments(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListStageDeploymentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStageDeploymentsResponse]
 */
public fun GameSparksClient.listStageDeploymentsPaginated(block: ListStageDeploymentsRequest.Builder.() -> Unit): Flow<ListStageDeploymentsResponse> =
    listStageDeploymentsPaginated(ListStageDeploymentsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listStageDeploymentsPaginated]
 * to access the nested member [StageDeploymentSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [StageDeploymentSummary]
 */
@JvmName("listStageDeploymentsResponseStageDeploymentSummary")
public fun Flow<ListStageDeploymentsResponse>.stageDeployments(): Flow<StageDeploymentSummary> =
    transform() { response ->
        response.stageDeployments?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListStagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStagesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStagesResponse]
 */
public fun GameSparksClient.listStagesPaginated(initialRequest: ListStagesRequest): Flow<ListStagesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listStagesPaginated.listStages(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListStagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStagesResponse]
 */
public fun GameSparksClient.listStagesPaginated(block: ListStagesRequest.Builder.() -> Unit): Flow<ListStagesResponse> =
    listStagesPaginated(ListStagesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listStagesPaginated]
 * to access the nested member [StageSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [StageSummary]
 */
@JvmName("listStagesResponseStageSummary")
public fun Flow<ListStagesResponse>.stages(): Flow<StageSummary> =
    transform() { response ->
        response.stages?.forEach {
            emit(it)
        }
    }
