// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamesparks.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Properties that provide details of a stage.
 */
public class StageDetails private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the stage.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The timestamp of when the stage was created.
     */
    public val created: aws.smithy.kotlin.runtime.time.Instant? = builder.created
    /**
     * The description of the stage.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The game key associated with the stage.
     *
     *  The game key is a unique identifier that the game client uses to connect to the GameSparks backend.
     */
    public val gameKey: kotlin.String? = builder.gameKey
    /**
     * The timestamp of when the stage was last updated.
     */
    public val lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdated
    /**
     * The Amazon CloudWatch log group for game runtimes deployed to the stage.
     */
    public val logGroup: kotlin.String? = builder.logGroup
    /**
     * The name of the stage.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the role used to run the game runtimes deployed to the stage.
     */
    public val role: kotlin.String? = builder.role
    /**
     * The state of the stage.
     */
    public val state: aws.sdk.kotlin.services.gamesparks.model.StageState? = builder.state
    /**
     * The tags associated with the stage.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamesparks.model.StageDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StageDetails(")
        append("arn=$arn,")
        append("created=$created,")
        append("description=$description,")
        append("gameKey=$gameKey,")
        append("lastUpdated=$lastUpdated,")
        append("logGroup=$logGroup,")
        append("name=$name,")
        append("role=$role,")
        append("state=$state,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (created?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (gameKey?.hashCode() ?: 0)
        result = 31 * result + (lastUpdated?.hashCode() ?: 0)
        result = 31 * result + (logGroup?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (role?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StageDetails

        if (arn != other.arn) return false
        if (created != other.created) return false
        if (description != other.description) return false
        if (gameKey != other.gameKey) return false
        if (lastUpdated != other.lastUpdated) return false
        if (logGroup != other.logGroup) return false
        if (name != other.name) return false
        if (role != other.role) return false
        if (state != other.state) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamesparks.model.StageDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the stage.
         */
        public var arn: kotlin.String? = null
        /**
         * The timestamp of when the stage was created.
         */
        public var created: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the stage.
         */
        public var description: kotlin.String? = null
        /**
         * The game key associated with the stage.
         *
         *  The game key is a unique identifier that the game client uses to connect to the GameSparks backend.
         */
        public var gameKey: kotlin.String? = null
        /**
         * The timestamp of when the stage was last updated.
         */
        public var lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon CloudWatch log group for game runtimes deployed to the stage.
         */
        public var logGroup: kotlin.String? = null
        /**
         * The name of the stage.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the role used to run the game runtimes deployed to the stage.
         */
        public var role: kotlin.String? = null
        /**
         * The state of the stage.
         */
        public var state: aws.sdk.kotlin.services.gamesparks.model.StageState? = null
        /**
         * The tags associated with the stage.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamesparks.model.StageDetails) : this() {
            this.arn = x.arn
            this.created = x.created
            this.description = x.description
            this.gameKey = x.gameKey
            this.lastUpdated = x.lastUpdated
            this.logGroup = x.logGroup
            this.name = x.name
            this.role = x.role
            this.state = x.state
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamesparks.model.StageDetails = StageDetails(this)
    }
}
