// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamesparks

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.gamesparks.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.gamesparks.endpoints.EndpointParameters
import aws.sdk.kotlin.services.gamesparks.endpoints.EndpointProvider
import aws.sdk.kotlin.services.gamesparks.model.CreateGameRequest
import aws.sdk.kotlin.services.gamesparks.model.CreateGameResponse
import aws.sdk.kotlin.services.gamesparks.model.CreateSnapshotRequest
import aws.sdk.kotlin.services.gamesparks.model.CreateSnapshotResponse
import aws.sdk.kotlin.services.gamesparks.model.CreateStageRequest
import aws.sdk.kotlin.services.gamesparks.model.CreateStageResponse
import aws.sdk.kotlin.services.gamesparks.model.DeleteGameRequest
import aws.sdk.kotlin.services.gamesparks.model.DeleteGameResponse
import aws.sdk.kotlin.services.gamesparks.model.DeleteStageRequest
import aws.sdk.kotlin.services.gamesparks.model.DeleteStageResponse
import aws.sdk.kotlin.services.gamesparks.model.DisconnectPlayerRequest
import aws.sdk.kotlin.services.gamesparks.model.DisconnectPlayerResponse
import aws.sdk.kotlin.services.gamesparks.model.ExportSnapshotRequest
import aws.sdk.kotlin.services.gamesparks.model.ExportSnapshotResponse
import aws.sdk.kotlin.services.gamesparks.model.GetExtensionRequest
import aws.sdk.kotlin.services.gamesparks.model.GetExtensionResponse
import aws.sdk.kotlin.services.gamesparks.model.GetExtensionVersionRequest
import aws.sdk.kotlin.services.gamesparks.model.GetExtensionVersionResponse
import aws.sdk.kotlin.services.gamesparks.model.GetGameConfigurationRequest
import aws.sdk.kotlin.services.gamesparks.model.GetGameConfigurationResponse
import aws.sdk.kotlin.services.gamesparks.model.GetGameRequest
import aws.sdk.kotlin.services.gamesparks.model.GetGameResponse
import aws.sdk.kotlin.services.gamesparks.model.GetGeneratedCodeJobRequest
import aws.sdk.kotlin.services.gamesparks.model.GetGeneratedCodeJobResponse
import aws.sdk.kotlin.services.gamesparks.model.GetPlayerConnectionStatusRequest
import aws.sdk.kotlin.services.gamesparks.model.GetPlayerConnectionStatusResponse
import aws.sdk.kotlin.services.gamesparks.model.GetSnapshotRequest
import aws.sdk.kotlin.services.gamesparks.model.GetSnapshotResponse
import aws.sdk.kotlin.services.gamesparks.model.GetStageDeploymentRequest
import aws.sdk.kotlin.services.gamesparks.model.GetStageDeploymentResponse
import aws.sdk.kotlin.services.gamesparks.model.GetStageRequest
import aws.sdk.kotlin.services.gamesparks.model.GetStageResponse
import aws.sdk.kotlin.services.gamesparks.model.ImportGameConfigurationRequest
import aws.sdk.kotlin.services.gamesparks.model.ImportGameConfigurationResponse
import aws.sdk.kotlin.services.gamesparks.model.ListExtensionVersionsRequest
import aws.sdk.kotlin.services.gamesparks.model.ListExtensionVersionsResponse
import aws.sdk.kotlin.services.gamesparks.model.ListExtensionsRequest
import aws.sdk.kotlin.services.gamesparks.model.ListExtensionsResponse
import aws.sdk.kotlin.services.gamesparks.model.ListGamesRequest
import aws.sdk.kotlin.services.gamesparks.model.ListGamesResponse
import aws.sdk.kotlin.services.gamesparks.model.ListGeneratedCodeJobsRequest
import aws.sdk.kotlin.services.gamesparks.model.ListGeneratedCodeJobsResponse
import aws.sdk.kotlin.services.gamesparks.model.ListSnapshotsRequest
import aws.sdk.kotlin.services.gamesparks.model.ListSnapshotsResponse
import aws.sdk.kotlin.services.gamesparks.model.ListStageDeploymentsRequest
import aws.sdk.kotlin.services.gamesparks.model.ListStageDeploymentsResponse
import aws.sdk.kotlin.services.gamesparks.model.ListStagesRequest
import aws.sdk.kotlin.services.gamesparks.model.ListStagesResponse
import aws.sdk.kotlin.services.gamesparks.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.gamesparks.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.gamesparks.model.StartGeneratedCodeJobRequest
import aws.sdk.kotlin.services.gamesparks.model.StartGeneratedCodeJobResponse
import aws.sdk.kotlin.services.gamesparks.model.StartStageDeploymentRequest
import aws.sdk.kotlin.services.gamesparks.model.StartStageDeploymentResponse
import aws.sdk.kotlin.services.gamesparks.model.TagResourceRequest
import aws.sdk.kotlin.services.gamesparks.model.TagResourceResponse
import aws.sdk.kotlin.services.gamesparks.model.UntagResourceRequest
import aws.sdk.kotlin.services.gamesparks.model.UntagResourceResponse
import aws.sdk.kotlin.services.gamesparks.model.UpdateGameConfigurationRequest
import aws.sdk.kotlin.services.gamesparks.model.UpdateGameConfigurationResponse
import aws.sdk.kotlin.services.gamesparks.model.UpdateGameRequest
import aws.sdk.kotlin.services.gamesparks.model.UpdateGameResponse
import aws.sdk.kotlin.services.gamesparks.model.UpdateSnapshotRequest
import aws.sdk.kotlin.services.gamesparks.model.UpdateSnapshotResponse
import aws.sdk.kotlin.services.gamesparks.model.UpdateStageRequest
import aws.sdk.kotlin.services.gamesparks.model.UpdateStageResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.internal.manage
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig
import kotlin.collections.List
import kotlin.jvm.JvmStatic

/**
 *
 */
public interface GameSparksClient : SdkClient {
    /**
     * GameSparksClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, GameSparksClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, GameSparksClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): GameSparksClient = DefaultGameSparksClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, SdkClientConfig, TracingClientConfig {
        override val clientName: String = builder.clientName
        override val httpClientEngine: HttpClientEngine = builder.httpClientEngine ?: DefaultHttpEngine().manage()
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region).manage()
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, clientName)
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            httpClientEngine = this@Config.httpClientEngine
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            tracer = this@Config.tracer
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, SdkClientConfig.Builder<Config>, TracingClientConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "GameSparks"

            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            override var httpClientEngine: HttpClientEngine? = null

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [HttpAuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            override var retryStrategy: RetryStrategy? = null

            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            override var tracer: Tracer? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a new game with an empty configuration. After creating your game, you can update the configuration using `UpdateGameConfiguration` or `ImportGameConfiguration`.
     */
    public suspend fun createGame(input: CreateGameRequest): CreateGameResponse

    /**
     * Creates a snapshot of the game configuration.
     */
    public suspend fun createSnapshot(input: CreateSnapshotRequest): CreateSnapshotResponse

    /**
     * Creates a new stage for stage-by-stage game development and deployment.
     */
    public suspend fun createStage(input: CreateStageRequest): CreateStageResponse

    /**
     * Deletes a game.
     */
    public suspend fun deleteGame(input: DeleteGameRequest): DeleteGameResponse

    /**
     * Deletes a stage from a game, along with the associated game runtime.
     */
    public suspend fun deleteStage(input: DeleteStageRequest): DeleteStageResponse

    /**
     * Disconnects a player from the game runtime.
     *
     *  If a player has multiple connections, this operation attempts to close all of them.
     */
    public suspend fun disconnectPlayer(input: DisconnectPlayerRequest): DisconnectPlayerResponse

    /**
     * Exports a game configuration snapshot.
     */
    public suspend fun exportSnapshot(input: ExportSnapshotRequest): ExportSnapshotResponse

    /**
     * Gets details about a specified extension.
     */
    public suspend fun getExtension(input: GetExtensionRequest): GetExtensionResponse

    /**
     * Gets details about a specified extension version.
     */
    public suspend fun getExtensionVersion(input: GetExtensionVersionRequest): GetExtensionVersionResponse

    /**
     * Gets details about a game.
     */
    public suspend fun getGame(input: GetGameRequest): GetGameResponse

    /**
     * Gets the configuration of the game.
     */
    public suspend fun getGameConfiguration(input: GetGameConfigurationRequest): GetGameConfigurationResponse

    /**
     * Gets details about a job that is generating code for a snapshot.
     */
    public suspend fun getGeneratedCodeJob(input: GetGeneratedCodeJobRequest): GetGeneratedCodeJobResponse

    /**
     * Gets the status of a player's connection to the game runtime.
     *
     *  It's possible for a single player to have multiple connections to the game runtime. If a player is not connected, this operation returns an empty list.
     */
    public suspend fun getPlayerConnectionStatus(input: GetPlayerConnectionStatusRequest): GetPlayerConnectionStatusResponse

    /**
     * Gets a copy of the game configuration in a snapshot.
     */
    public suspend fun getSnapshot(input: GetSnapshotRequest): GetSnapshotResponse

    /**
     * Gets information about a stage.
     */
    public suspend fun getStage(input: GetStageRequest): GetStageResponse

    /**
     * Gets information about a stage deployment.
     */
    public suspend fun getStageDeployment(input: GetStageDeploymentRequest): GetStageDeploymentResponse

    /**
     * Imports a game configuration.
     *
     *  This operation replaces the current configuration of the game with the provided input. This is not a reversible operation. If you want to preserve the previous configuration, use `CreateSnapshot` to make a new snapshot before importing.
     */
    public suspend fun importGameConfiguration(input: ImportGameConfigurationRequest): ImportGameConfigurationResponse

    /**
     * Gets a paginated list of available versions for the extension.
     *
     *  Each time an API change is made to an extension, the version is incremented. The list retrieved by this operation shows the versions that are currently available.
     */
    public suspend fun listExtensionVersions(input: ListExtensionVersionsRequest): ListExtensionVersionsResponse

    /**
     * Gets a paginated list of available extensions.
     *
     *  Extensions provide features that games can use from scripts.
     */
    public suspend fun listExtensions(input: ListExtensionsRequest = ListExtensionsRequest {}): ListExtensionsResponse

    /**
     * Gets a paginated list of games.
     */
    public suspend fun listGames(input: ListGamesRequest = ListGamesRequest {}): ListGamesResponse

    /**
     * Gets a paginated list of code generation jobs for a snapshot.
     */
    public suspend fun listGeneratedCodeJobs(input: ListGeneratedCodeJobsRequest): ListGeneratedCodeJobsResponse

    /**
     * Gets a paginated list of snapshot summaries from the game.
     */
    public suspend fun listSnapshots(input: ListSnapshotsRequest): ListSnapshotsResponse

    /**
     * Gets a paginated list of stage deployment summaries from the game.
     */
    public suspend fun listStageDeployments(input: ListStageDeploymentsRequest): ListStageDeploymentsResponse

    /**
     * Gets a paginated list of stage summaries from the game.
     */
    public suspend fun listStages(input: ListStagesRequest): ListStagesResponse

    /**
     * Lists the tags associated with a GameSparks resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Starts an asynchronous process that generates client code for system-defined and custom messages. The resulting code is collected as a .zip file and uploaded to a pre-signed Amazon S3 URL.
     */
    public suspend fun startGeneratedCodeJob(input: StartGeneratedCodeJobRequest): StartGeneratedCodeJobResponse

    /**
     * Deploys a snapshot to the stage and creates a new game runtime.
     *
     *  After you call this operation, you can check the deployment status by using `GetStageDeployment`.
     *
     *  If there are any players connected to the previous game runtime, then both runtimes persist. Existing connections to the previous runtime are maintained. When players disconnect and reconnect, they connect to the new runtime. After there are no connections to the previous game runtime, it is deleted.
     */
    public suspend fun startStageDeployment(input: StartStageDeploymentRequest): StartStageDeploymentResponse

    /**
     * Adds tags to a GameSparks resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from a GameSparks resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates details of the game.
     */
    public suspend fun updateGame(input: UpdateGameRequest): UpdateGameResponse

    /**
     * Updates one or more sections of the game configuration.
     */
    public suspend fun updateGameConfiguration(input: UpdateGameConfigurationRequest): UpdateGameConfigurationResponse

    /**
     * Updates the metadata of a GameSparks snapshot.
     */
    public suspend fun updateSnapshot(input: UpdateSnapshotRequest): UpdateSnapshotResponse

    /**
     * Updates the metadata of a stage.
     */
    public suspend fun updateStage(input: UpdateStageRequest): UpdateStageResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun GameSparksClient.withConfig(block: GameSparksClient.Config.Builder.() -> Unit): GameSparksClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultGameSparksClient(newConfig)
}

/**
 * Creates a new game with an empty configuration. After creating your game, you can update the configuration using `UpdateGameConfiguration` or `ImportGameConfiguration`.
 */
public suspend inline fun GameSparksClient.createGame(crossinline block: CreateGameRequest.Builder.() -> Unit): CreateGameResponse = createGame(CreateGameRequest.Builder().apply(block).build())

/**
 * Creates a snapshot of the game configuration.
 */
public suspend inline fun GameSparksClient.createSnapshot(crossinline block: CreateSnapshotRequest.Builder.() -> Unit): CreateSnapshotResponse = createSnapshot(CreateSnapshotRequest.Builder().apply(block).build())

/**
 * Creates a new stage for stage-by-stage game development and deployment.
 */
public suspend inline fun GameSparksClient.createStage(crossinline block: CreateStageRequest.Builder.() -> Unit): CreateStageResponse = createStage(CreateStageRequest.Builder().apply(block).build())

/**
 * Deletes a game.
 */
public suspend inline fun GameSparksClient.deleteGame(crossinline block: DeleteGameRequest.Builder.() -> Unit): DeleteGameResponse = deleteGame(DeleteGameRequest.Builder().apply(block).build())

/**
 * Deletes a stage from a game, along with the associated game runtime.
 */
public suspend inline fun GameSparksClient.deleteStage(crossinline block: DeleteStageRequest.Builder.() -> Unit): DeleteStageResponse = deleteStage(DeleteStageRequest.Builder().apply(block).build())

/**
 * Disconnects a player from the game runtime.
 *
 *  If a player has multiple connections, this operation attempts to close all of them.
 */
public suspend inline fun GameSparksClient.disconnectPlayer(crossinline block: DisconnectPlayerRequest.Builder.() -> Unit): DisconnectPlayerResponse = disconnectPlayer(DisconnectPlayerRequest.Builder().apply(block).build())

/**
 * Exports a game configuration snapshot.
 */
public suspend inline fun GameSparksClient.exportSnapshot(crossinline block: ExportSnapshotRequest.Builder.() -> Unit): ExportSnapshotResponse = exportSnapshot(ExportSnapshotRequest.Builder().apply(block).build())

/**
 * Gets details about a specified extension.
 */
public suspend inline fun GameSparksClient.getExtension(crossinline block: GetExtensionRequest.Builder.() -> Unit): GetExtensionResponse = getExtension(GetExtensionRequest.Builder().apply(block).build())

/**
 * Gets details about a specified extension version.
 */
public suspend inline fun GameSparksClient.getExtensionVersion(crossinline block: GetExtensionVersionRequest.Builder.() -> Unit): GetExtensionVersionResponse = getExtensionVersion(GetExtensionVersionRequest.Builder().apply(block).build())

/**
 * Gets details about a game.
 */
public suspend inline fun GameSparksClient.getGame(crossinline block: GetGameRequest.Builder.() -> Unit): GetGameResponse = getGame(GetGameRequest.Builder().apply(block).build())

/**
 * Gets the configuration of the game.
 */
public suspend inline fun GameSparksClient.getGameConfiguration(crossinline block: GetGameConfigurationRequest.Builder.() -> Unit): GetGameConfigurationResponse = getGameConfiguration(GetGameConfigurationRequest.Builder().apply(block).build())

/**
 * Gets details about a job that is generating code for a snapshot.
 */
public suspend inline fun GameSparksClient.getGeneratedCodeJob(crossinline block: GetGeneratedCodeJobRequest.Builder.() -> Unit): GetGeneratedCodeJobResponse = getGeneratedCodeJob(GetGeneratedCodeJobRequest.Builder().apply(block).build())

/**
 * Gets the status of a player's connection to the game runtime.
 *
 *  It's possible for a single player to have multiple connections to the game runtime. If a player is not connected, this operation returns an empty list.
 */
public suspend inline fun GameSparksClient.getPlayerConnectionStatus(crossinline block: GetPlayerConnectionStatusRequest.Builder.() -> Unit): GetPlayerConnectionStatusResponse = getPlayerConnectionStatus(GetPlayerConnectionStatusRequest.Builder().apply(block).build())

/**
 * Gets a copy of the game configuration in a snapshot.
 */
public suspend inline fun GameSparksClient.getSnapshot(crossinline block: GetSnapshotRequest.Builder.() -> Unit): GetSnapshotResponse = getSnapshot(GetSnapshotRequest.Builder().apply(block).build())

/**
 * Gets information about a stage.
 */
public suspend inline fun GameSparksClient.getStage(crossinline block: GetStageRequest.Builder.() -> Unit): GetStageResponse = getStage(GetStageRequest.Builder().apply(block).build())

/**
 * Gets information about a stage deployment.
 */
public suspend inline fun GameSparksClient.getStageDeployment(crossinline block: GetStageDeploymentRequest.Builder.() -> Unit): GetStageDeploymentResponse = getStageDeployment(GetStageDeploymentRequest.Builder().apply(block).build())

/**
 * Imports a game configuration.
 *
 *  This operation replaces the current configuration of the game with the provided input. This is not a reversible operation. If you want to preserve the previous configuration, use `CreateSnapshot` to make a new snapshot before importing.
 */
public suspend inline fun GameSparksClient.importGameConfiguration(crossinline block: ImportGameConfigurationRequest.Builder.() -> Unit): ImportGameConfigurationResponse = importGameConfiguration(ImportGameConfigurationRequest.Builder().apply(block).build())

/**
 * Gets a paginated list of available versions for the extension.
 *
 *  Each time an API change is made to an extension, the version is incremented. The list retrieved by this operation shows the versions that are currently available.
 */
public suspend inline fun GameSparksClient.listExtensionVersions(crossinline block: ListExtensionVersionsRequest.Builder.() -> Unit): ListExtensionVersionsResponse = listExtensionVersions(ListExtensionVersionsRequest.Builder().apply(block).build())

/**
 * Gets a paginated list of available extensions.
 *
 *  Extensions provide features that games can use from scripts.
 */
public suspend inline fun GameSparksClient.listExtensions(crossinline block: ListExtensionsRequest.Builder.() -> Unit): ListExtensionsResponse = listExtensions(ListExtensionsRequest.Builder().apply(block).build())

/**
 * Gets a paginated list of games.
 */
public suspend inline fun GameSparksClient.listGames(crossinline block: ListGamesRequest.Builder.() -> Unit): ListGamesResponse = listGames(ListGamesRequest.Builder().apply(block).build())

/**
 * Gets a paginated list of code generation jobs for a snapshot.
 */
public suspend inline fun GameSparksClient.listGeneratedCodeJobs(crossinline block: ListGeneratedCodeJobsRequest.Builder.() -> Unit): ListGeneratedCodeJobsResponse = listGeneratedCodeJobs(ListGeneratedCodeJobsRequest.Builder().apply(block).build())

/**
 * Gets a paginated list of snapshot summaries from the game.
 */
public suspend inline fun GameSparksClient.listSnapshots(crossinline block: ListSnapshotsRequest.Builder.() -> Unit): ListSnapshotsResponse = listSnapshots(ListSnapshotsRequest.Builder().apply(block).build())

/**
 * Gets a paginated list of stage deployment summaries from the game.
 */
public suspend inline fun GameSparksClient.listStageDeployments(crossinline block: ListStageDeploymentsRequest.Builder.() -> Unit): ListStageDeploymentsResponse = listStageDeployments(ListStageDeploymentsRequest.Builder().apply(block).build())

/**
 * Gets a paginated list of stage summaries from the game.
 */
public suspend inline fun GameSparksClient.listStages(crossinline block: ListStagesRequest.Builder.() -> Unit): ListStagesResponse = listStages(ListStagesRequest.Builder().apply(block).build())

/**
 * Lists the tags associated with a GameSparks resource.
 */
public suspend inline fun GameSparksClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Starts an asynchronous process that generates client code for system-defined and custom messages. The resulting code is collected as a .zip file and uploaded to a pre-signed Amazon S3 URL.
 */
public suspend inline fun GameSparksClient.startGeneratedCodeJob(crossinline block: StartGeneratedCodeJobRequest.Builder.() -> Unit): StartGeneratedCodeJobResponse = startGeneratedCodeJob(StartGeneratedCodeJobRequest.Builder().apply(block).build())

/**
 * Deploys a snapshot to the stage and creates a new game runtime.
 *
 *  After you call this operation, you can check the deployment status by using `GetStageDeployment`.
 *
 *  If there are any players connected to the previous game runtime, then both runtimes persist. Existing connections to the previous runtime are maintained. When players disconnect and reconnect, they connect to the new runtime. After there are no connections to the previous game runtime, it is deleted.
 */
public suspend inline fun GameSparksClient.startStageDeployment(crossinline block: StartStageDeploymentRequest.Builder.() -> Unit): StartStageDeploymentResponse = startStageDeployment(StartStageDeploymentRequest.Builder().apply(block).build())

/**
 * Adds tags to a GameSparks resource.
 */
public suspend inline fun GameSparksClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from a GameSparks resource.
 */
public suspend inline fun GameSparksClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates details of the game.
 */
public suspend inline fun GameSparksClient.updateGame(crossinline block: UpdateGameRequest.Builder.() -> Unit): UpdateGameResponse = updateGame(UpdateGameRequest.Builder().apply(block).build())

/**
 * Updates one or more sections of the game configuration.
 */
public suspend inline fun GameSparksClient.updateGameConfiguration(crossinline block: UpdateGameConfigurationRequest.Builder.() -> Unit): UpdateGameConfigurationResponse = updateGameConfiguration(UpdateGameConfigurationRequest.Builder().apply(block).build())

/**
 * Updates the metadata of a GameSparks snapshot.
 */
public suspend inline fun GameSparksClient.updateSnapshot(crossinline block: UpdateSnapshotRequest.Builder.() -> Unit): UpdateSnapshotResponse = updateSnapshot(UpdateSnapshotRequest.Builder().apply(block).build())

/**
 * Updates the metadata of a stage.
 */
public suspend inline fun GameSparksClient.updateStage(crossinline block: UpdateStageRequest.Builder.() -> Unit): UpdateStageResponse = updateStage(UpdateStageRequest.Builder().apply(block).build())
