// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.serde

import aws.sdk.kotlin.services.gamelift.model.GameLiftException
import aws.sdk.kotlin.services.gamelift.model.StopFleetActionsResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class StopFleetActionsOperationDeserializer: HttpDeserializer.NonStreaming<StopFleetActionsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): StopFleetActionsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwStopFleetActionsError(context, call, payload)
        }
        val builder = StopFleetActionsResponse.Builder()

        if (payload != null) {
            deserializeStopFleetActionsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwStopFleetActionsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw GameLiftException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedRegionException" -> UnsupportedRegionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> GameLiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStopFleetActionsOperationBody(builder: StopFleetActionsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FLEETARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FleetArn"))
    val FLEETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FleetId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FLEETARN_DESCRIPTOR)
        field(FLEETID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FLEETARN_DESCRIPTOR.index -> builder.fleetArn = deserializeString()
                FLEETID_DESCRIPTOR.index -> builder.fleetId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
