// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.serde

import aws.sdk.kotlin.services.gamelift.model.GameLiftException
import aws.sdk.kotlin.services.gamelift.model.GetComputeAuthTokenResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetComputeAuthTokenOperationDeserializer: HttpDeserializer.NonStreaming<GetComputeAuthTokenResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetComputeAuthTokenResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetComputeAuthTokenError(context, call, payload)
        }
        val builder = GetComputeAuthTokenResponse.Builder()

        if (payload != null) {
            deserializeGetComputeAuthTokenOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetComputeAuthTokenError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw GameLiftException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedRegionException" -> UnsupportedRegionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> GameLiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetComputeAuthTokenOperationBody(builder: GetComputeAuthTokenResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUTHTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AuthToken"))
    val COMPUTEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ComputeArn"))
    val COMPUTENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ComputeName"))
    val EXPIRATIONTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ExpirationTimestamp"))
    val FLEETARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FleetArn"))
    val FLEETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FleetId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTHTOKEN_DESCRIPTOR)
        field(COMPUTEARN_DESCRIPTOR)
        field(COMPUTENAME_DESCRIPTOR)
        field(EXPIRATIONTIMESTAMP_DESCRIPTOR)
        field(FLEETARN_DESCRIPTOR)
        field(FLEETID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTHTOKEN_DESCRIPTOR.index -> builder.authToken = deserializeString()
                COMPUTEARN_DESCRIPTOR.index -> builder.computeArn = deserializeString()
                COMPUTENAME_DESCRIPTOR.index -> builder.computeName = deserializeString()
                EXPIRATIONTIMESTAMP_DESCRIPTOR.index -> builder.expirationTimestamp = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                FLEETARN_DESCRIPTOR.index -> builder.fleetArn = deserializeString()
                FLEETID_DESCRIPTOR.index -> builder.fleetId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
