// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.serde

import aws.sdk.kotlin.services.gamelift.model.AwsCredentials
import aws.sdk.kotlin.services.gamelift.model.ContainerIdentifier
import aws.sdk.kotlin.services.gamelift.model.GameLiftException
import aws.sdk.kotlin.services.gamelift.model.GetComputeAccessResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetComputeAccessOperationDeserializer: HttpDeserializer.NonStreaming<GetComputeAccessResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetComputeAccessResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetComputeAccessError(context, call, payload)
        }
        val builder = GetComputeAccessResponse.Builder()

        if (payload != null) {
            deserializeGetComputeAccessOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetComputeAccessError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw GameLiftException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedRegionException" -> UnsupportedRegionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> GameLiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetComputeAccessOperationBody(builder: GetComputeAccessResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMPUTEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ComputeArn"))
    val COMPUTENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ComputeName"))
    val CONTAINERIDENTIFIERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ContainerIdentifiers"))
    val CREDENTIALS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Credentials"))
    val FLEETARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FleetArn"))
    val FLEETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FleetId"))
    val TARGET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Target"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMPUTEARN_DESCRIPTOR)
        field(COMPUTENAME_DESCRIPTOR)
        field(CONTAINERIDENTIFIERS_DESCRIPTOR)
        field(CREDENTIALS_DESCRIPTOR)
        field(FLEETARN_DESCRIPTOR)
        field(FLEETID_DESCRIPTOR)
        field(TARGET_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMPUTEARN_DESCRIPTOR.index -> builder.computeArn = deserializeString()
                COMPUTENAME_DESCRIPTOR.index -> builder.computeName = deserializeString()
                CONTAINERIDENTIFIERS_DESCRIPTOR.index -> builder.containerIdentifiers =
                    deserializer.deserializeList(CONTAINERIDENTIFIERS_DESCRIPTOR) {
                        val col0 = mutableListOf<ContainerIdentifier>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeContainerIdentifierDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CREDENTIALS_DESCRIPTOR.index -> builder.credentials = deserializeAwsCredentialsDocument(deserializer)
                FLEETARN_DESCRIPTOR.index -> builder.fleetArn = deserializeString()
                FLEETID_DESCRIPTOR.index -> builder.fleetId = deserializeString()
                TARGET_DESCRIPTOR.index -> builder.target = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
