// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.serde

import aws.sdk.kotlin.services.gamelift.model.DescribeFleetPortSettingsResponse
import aws.sdk.kotlin.services.gamelift.model.GameLiftException
import aws.sdk.kotlin.services.gamelift.model.IpPermission
import aws.sdk.kotlin.services.gamelift.model.LocationUpdateStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeFleetPortSettingsOperationDeserializer: HttpDeserializer.NonStreaming<DescribeFleetPortSettingsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeFleetPortSettingsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeFleetPortSettingsError(context, call, payload)
        }
        val builder = DescribeFleetPortSettingsResponse.Builder()

        if (payload != null) {
            deserializeDescribeFleetPortSettingsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeFleetPortSettingsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw GameLiftException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedRegionException" -> UnsupportedRegionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> GameLiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeFleetPortSettingsOperationBody(builder: DescribeFleetPortSettingsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FLEETARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FleetArn"))
    val FLEETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FleetId"))
    val INBOUNDPERMISSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("InboundPermissions"))
    val LOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Location"))
    val UPDATESTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("UpdateStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FLEETARN_DESCRIPTOR)
        field(FLEETID_DESCRIPTOR)
        field(INBOUNDPERMISSIONS_DESCRIPTOR)
        field(LOCATION_DESCRIPTOR)
        field(UPDATESTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FLEETARN_DESCRIPTOR.index -> builder.fleetArn = deserializeString()
                FLEETID_DESCRIPTOR.index -> builder.fleetId = deserializeString()
                INBOUNDPERMISSIONS_DESCRIPTOR.index -> builder.inboundPermissions =
                    deserializer.deserializeList(INBOUNDPERMISSIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<IpPermission>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeIpPermissionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                LOCATION_DESCRIPTOR.index -> builder.location = deserializeString()
                UPDATESTATUS_DESCRIPTOR.index -> builder.updateStatus = deserializeString().let { LocationUpdateStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
