// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.serde

import aws.sdk.kotlin.services.gamelift.model.CreateMatchmakingRuleSetResponse
import aws.sdk.kotlin.services.gamelift.model.GameLiftException
import aws.sdk.kotlin.services.gamelift.model.MatchmakingRuleSet
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateMatchmakingRuleSetOperationDeserializer: HttpDeserializer.NonStreaming<CreateMatchmakingRuleSetResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateMatchmakingRuleSetResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateMatchmakingRuleSetError(context, call, payload)
        }
        val builder = CreateMatchmakingRuleSetResponse.Builder()

        if (payload != null) {
            deserializeCreateMatchmakingRuleSetOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateMatchmakingRuleSetError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw GameLiftException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TaggingFailedException" -> TaggingFailedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedRegionException" -> UnsupportedRegionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> GameLiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateMatchmakingRuleSetOperationBody(builder: CreateMatchmakingRuleSetResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val RULESET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("RuleSet"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(RULESET_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                RULESET_DESCRIPTOR.index -> builder.ruleSet = deserializeMatchmakingRuleSetDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
