// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.serde

import aws.sdk.kotlin.services.gamelift.model.CreateFleetResponse
import aws.sdk.kotlin.services.gamelift.model.FleetAttributes
import aws.sdk.kotlin.services.gamelift.model.GameLiftException
import aws.sdk.kotlin.services.gamelift.model.LocationState
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class CreateFleetOperationDeserializer: HttpDeserializer.NonStreaming<CreateFleetResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateFleetResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateFleetError(context, call, payload)
        }
        val builder = CreateFleetResponse.Builder()

        if (payload != null) {
            deserializeCreateFleetOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateFleetError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw GameLiftException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotReadyException" -> NotReadyExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TaggingFailedException" -> TaggingFailedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedRegionException" -> UnsupportedRegionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> GameLiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateFleetOperationBody(builder: CreateFleetResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FLEETATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("FleetAttributes"))
    val LOCATIONSTATES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("LocationStates"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FLEETATTRIBUTES_DESCRIPTOR)
        field(LOCATIONSTATES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FLEETATTRIBUTES_DESCRIPTOR.index -> builder.fleetAttributes = deserializeFleetAttributesDocument(deserializer)
                LOCATIONSTATES_DESCRIPTOR.index -> builder.locationStates =
                    deserializer.deserializeList(LOCATIONSTATES_DESCRIPTOR) {
                        val col0 = mutableListOf<LocationState>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeLocationStateDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
