// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateScriptRequest private constructor(builder: Builder) {
    /**
     * A descriptive label that is associated with a script. Script names do not need to be unique.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A unique identifier for the Realtime script to update. You can use either the script ID or ARN value.
     */
    public val scriptId: kotlin.String? = builder.scriptId
    /**
     * The location of the Amazon S3 bucket where a zipped file containing your Realtime scripts is stored. The storage location must specify the Amazon S3 bucket name, the zip file name (the "key"), and a role ARN that allows Amazon GameLift Servers to access the Amazon S3 storage location. The S3 bucket must be in the same Region where you want to create a new script. By default, Amazon GameLift Servers uploads the latest version of the zip file; if you have S3 object versioning turned on, you can use the `ObjectVersion` parameter to specify an earlier version.
     */
    public val storageLocation: aws.sdk.kotlin.services.gamelift.model.S3Location? = builder.storageLocation
    /**
     * Version information that is associated with a build or script. Version strings do not need to be unique.
     */
    public val version: kotlin.String? = builder.version
    /**
     * A data object containing your Realtime scripts and dependencies as a zip file. The zip file can have one or multiple files. Maximum size of a zip file is 5 MB.
     *
     * When using the Amazon Web Services CLI tool to create a script, this parameter is set to the zip file name. It must be prepended with the string "fileb://" to indicate that the file data is a binary object. For example: `--zip-file fileb://myRealtimeScript.zip`.
     */
    public val zipFile: kotlin.ByteArray? = builder.zipFile

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.UpdateScriptRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateScriptRequest(")
        append("name=$name,")
        append("scriptId=$scriptId,")
        append("storageLocation=$storageLocation,")
        append("version=$version,")
        append("zipFile=$zipFile")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (scriptId?.hashCode() ?: 0)
        result = 31 * result + (storageLocation?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        result = 31 * result + (zipFile?.contentHashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateScriptRequest

        if (name != other.name) return false
        if (scriptId != other.scriptId) return false
        if (storageLocation != other.storageLocation) return false
        if (version != other.version) return false
        if (zipFile != null) {
            if (other.zipFile == null) return false
            if (!zipFile.contentEquals(other.zipFile)) return false
        } else if (other.zipFile != null) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.UpdateScriptRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A descriptive label that is associated with a script. Script names do not need to be unique.
         */
        public var name: kotlin.String? = null
        /**
         * A unique identifier for the Realtime script to update. You can use either the script ID or ARN value.
         */
        public var scriptId: kotlin.String? = null
        /**
         * The location of the Amazon S3 bucket where a zipped file containing your Realtime scripts is stored. The storage location must specify the Amazon S3 bucket name, the zip file name (the "key"), and a role ARN that allows Amazon GameLift Servers to access the Amazon S3 storage location. The S3 bucket must be in the same Region where you want to create a new script. By default, Amazon GameLift Servers uploads the latest version of the zip file; if you have S3 object versioning turned on, you can use the `ObjectVersion` parameter to specify an earlier version.
         */
        public var storageLocation: aws.sdk.kotlin.services.gamelift.model.S3Location? = null
        /**
         * Version information that is associated with a build or script. Version strings do not need to be unique.
         */
        public var version: kotlin.String? = null
        /**
         * A data object containing your Realtime scripts and dependencies as a zip file. The zip file can have one or multiple files. Maximum size of a zip file is 5 MB.
         *
         * When using the Amazon Web Services CLI tool to create a script, this parameter is set to the zip file name. It must be prepended with the string "fileb://" to indicate that the file data is a binary object. For example: `--zip-file fileb://myRealtimeScript.zip`.
         */
        public var zipFile: kotlin.ByteArray? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.UpdateScriptRequest) : this() {
            this.name = x.name
            this.scriptId = x.scriptId
            this.storageLocation = x.storageLocation
            this.version = x.version
            this.zipFile = x.zipFile
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.UpdateScriptRequest = UpdateScriptRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.S3Location] inside the given [block]
         */
        public fun storageLocation(block: aws.sdk.kotlin.services.gamelift.model.S3Location.Builder.() -> kotlin.Unit) {
            this.storageLocation = aws.sdk.kotlin.services.gamelift.model.S3Location.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
