// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateContainerGroupDefinitionRequest private constructor(builder: Builder) {
    /**
     * An updated definition for the game server container in this group. Define a game server container only when the container group type is `GAME_SERVER`. You can pass in your container definitions as a JSON file.
     */
    public val gameServerContainerDefinition: aws.sdk.kotlin.services.gamelift.model.GameServerContainerDefinitionInput? = builder.gameServerContainerDefinition
    /**
     * A descriptive identifier for the container group definition. The name value must be unique in an Amazon Web Services Region.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The platform that all containers in the group use. Containers in a group must run on the same operating system.
     *
     * Amazon Linux 2 (AL2) will reach end of support on 6/30/2025. See more details in the [Amazon Linux 2 FAQs](http://aws.amazon.com/amazon-linux-2/faqs/). For game servers that are hosted on AL2 and use server SDK version 4.x for Amazon GameLift Servers, first update the game server build to server SDK 5.x, and then deploy to AL2023 instances. See [ Migrate to server SDK version 5.](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk5-migration.html)
     */
    public val operatingSystem: aws.sdk.kotlin.services.gamelift.model.ContainerOperatingSystem? = builder.operatingSystem
    /**
     * The container group definition version to update. The new version starts with values from the source version, and then updates values included in this request.
     */
    public val sourceVersionNumber: kotlin.Int? = builder.sourceVersionNumber
    /**
     * One or more definitions for support containers in this group. You can define a support container in any type of container group. You can pass in your container definitions as a JSON file.
     */
    public val supportContainerDefinitions: List<SupportContainerDefinitionInput>? = builder.supportContainerDefinitions
    /**
     * The maximum amount of memory (in MiB) to allocate to the container group. All containers in the group share this memory. If you specify memory limits for an individual container, the total value must be greater than any individual container's memory limit.
     */
    public val totalMemoryLimitMebibytes: kotlin.Int? = builder.totalMemoryLimitMebibytes
    /**
     * The maximum amount of vCPU units to allocate to the container group (1 vCPU is equal to 1024 CPU units). All containers in the group share this memory. If you specify vCPU limits for individual containers, the total value must be equal to or greater than the sum of the CPU limits for all containers in the group.
     */
    public val totalVcpuLimit: kotlin.Double? = builder.totalVcpuLimit
    /**
     * A description for this update to the container group definition.
     */
    public val versionDescription: kotlin.String? = builder.versionDescription

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.UpdateContainerGroupDefinitionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateContainerGroupDefinitionRequest(")
        append("gameServerContainerDefinition=$gameServerContainerDefinition,")
        append("name=$name,")
        append("operatingSystem=$operatingSystem,")
        append("sourceVersionNumber=$sourceVersionNumber,")
        append("supportContainerDefinitions=$supportContainerDefinitions,")
        append("totalMemoryLimitMebibytes=$totalMemoryLimitMebibytes,")
        append("totalVcpuLimit=$totalVcpuLimit,")
        append("versionDescription=$versionDescription")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = gameServerContainerDefinition?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (operatingSystem?.hashCode() ?: 0)
        result = 31 * result + (sourceVersionNumber ?: 0)
        result = 31 * result + (supportContainerDefinitions?.hashCode() ?: 0)
        result = 31 * result + (totalMemoryLimitMebibytes ?: 0)
        result = 31 * result + (totalVcpuLimit?.hashCode() ?: 0)
        result = 31 * result + (versionDescription?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateContainerGroupDefinitionRequest

        if (gameServerContainerDefinition != other.gameServerContainerDefinition) return false
        if (name != other.name) return false
        if (operatingSystem != other.operatingSystem) return false
        if (sourceVersionNumber != other.sourceVersionNumber) return false
        if (supportContainerDefinitions != other.supportContainerDefinitions) return false
        if (totalMemoryLimitMebibytes != other.totalMemoryLimitMebibytes) return false
        if (!(totalVcpuLimit?.equals(other.totalVcpuLimit) ?: (other.totalVcpuLimit == null))) return false
        if (versionDescription != other.versionDescription) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.UpdateContainerGroupDefinitionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An updated definition for the game server container in this group. Define a game server container only when the container group type is `GAME_SERVER`. You can pass in your container definitions as a JSON file.
         */
        public var gameServerContainerDefinition: aws.sdk.kotlin.services.gamelift.model.GameServerContainerDefinitionInput? = null
        /**
         * A descriptive identifier for the container group definition. The name value must be unique in an Amazon Web Services Region.
         */
        public var name: kotlin.String? = null
        /**
         * The platform that all containers in the group use. Containers in a group must run on the same operating system.
         *
         * Amazon Linux 2 (AL2) will reach end of support on 6/30/2025. See more details in the [Amazon Linux 2 FAQs](http://aws.amazon.com/amazon-linux-2/faqs/). For game servers that are hosted on AL2 and use server SDK version 4.x for Amazon GameLift Servers, first update the game server build to server SDK 5.x, and then deploy to AL2023 instances. See [ Migrate to server SDK version 5.](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk5-migration.html)
         */
        public var operatingSystem: aws.sdk.kotlin.services.gamelift.model.ContainerOperatingSystem? = null
        /**
         * The container group definition version to update. The new version starts with values from the source version, and then updates values included in this request.
         */
        public var sourceVersionNumber: kotlin.Int? = null
        /**
         * One or more definitions for support containers in this group. You can define a support container in any type of container group. You can pass in your container definitions as a JSON file.
         */
        public var supportContainerDefinitions: List<SupportContainerDefinitionInput>? = null
        /**
         * The maximum amount of memory (in MiB) to allocate to the container group. All containers in the group share this memory. If you specify memory limits for an individual container, the total value must be greater than any individual container's memory limit.
         */
        public var totalMemoryLimitMebibytes: kotlin.Int? = null
        /**
         * The maximum amount of vCPU units to allocate to the container group (1 vCPU is equal to 1024 CPU units). All containers in the group share this memory. If you specify vCPU limits for individual containers, the total value must be equal to or greater than the sum of the CPU limits for all containers in the group.
         */
        public var totalVcpuLimit: kotlin.Double? = null
        /**
         * A description for this update to the container group definition.
         */
        public var versionDescription: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.UpdateContainerGroupDefinitionRequest) : this() {
            this.gameServerContainerDefinition = x.gameServerContainerDefinition
            this.name = x.name
            this.operatingSystem = x.operatingSystem
            this.sourceVersionNumber = x.sourceVersionNumber
            this.supportContainerDefinitions = x.supportContainerDefinitions
            this.totalMemoryLimitMebibytes = x.totalMemoryLimitMebibytes
            this.totalVcpuLimit = x.totalVcpuLimit
            this.versionDescription = x.versionDescription
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.UpdateContainerGroupDefinitionRequest = UpdateContainerGroupDefinitionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.GameServerContainerDefinitionInput] inside the given [block]
         */
        public fun gameServerContainerDefinition(block: aws.sdk.kotlin.services.gamelift.model.GameServerContainerDefinitionInput.Builder.() -> kotlin.Unit) {
            this.gameServerContainerDefinition = aws.sdk.kotlin.services.gamelift.model.GameServerContainerDefinitionInput.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
