// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateContainerFleetRequest private constructor(builder: Builder) {
    /**
     * Instructions for how to deploy updates to a container fleet, if the fleet update initiates a deployment. The deployment configuration lets you determine how to replace fleet instances and what actions to take if the deployment fails.
     */
    public val deploymentConfiguration: aws.sdk.kotlin.services.gamelift.model.DeploymentConfiguration? = builder.deploymentConfiguration
    /**
     * A meaningful description of the container fleet.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A unique identifier for the container fleet to update. You can use either the fleet ID or ARN value.
     */
    public val fleetId: kotlin.String? = builder.fleetId
    /**
     * The name or ARN value of a new game server container group definition to deploy on the fleet. If you're updating the fleet to a specific version of a container group definition, use the ARN value and include the version number. If you're updating the fleet to the latest version of a container group definition, you can use the name value. You can't remove a fleet's game server container group definition, you can only update or replace it with another definition.
     *
     * Update a container group definition by calling [UpdateContainerGroupDefinition](https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateContainerGroupDefinition.html). This operation creates a [ContainerGroupDefinition](https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html) resource with an incremented version.
     */
    public val gameServerContainerGroupDefinitionName: kotlin.String? = builder.gameServerContainerGroupDefinitionName
    /**
     * The number of times to replicate the game server container group on each fleet instance. By default, Amazon GameLift Servers calculates the maximum number of game server container groups that can fit on each instance. You can remove this property value to use the calculated value, or set it manually. If you set this number manually, Amazon GameLift Servers uses your value as long as it's less than the calculated maximum.
     */
    public val gameServerContainerGroupsPerInstance: kotlin.Int? = builder.gameServerContainerGroupsPerInstance
    /**
     * A policy that limits the number of game sessions that each individual player can create on instances in this fleet. The limit applies for a specified span of time.
     */
    public val gameSessionCreationLimitPolicy: aws.sdk.kotlin.services.gamelift.model.GameSessionCreationLimitPolicy? = builder.gameSessionCreationLimitPolicy
    /**
     * A revised set of port numbers to open on each fleet instance. By default, Amazon GameLift Servers calculates an optimal port range based on your fleet configuration. If you previously set this parameter manually, you can't reset this to use the calculated settings.
     */
    public val instanceConnectionPortRange: aws.sdk.kotlin.services.gamelift.model.ConnectionPortRange? = builder.instanceConnectionPortRange
    /**
     * A set of ports to add to the container fleet's inbound permissions.
     */
    public val instanceInboundPermissionAuthorizations: List<IpPermission>? = builder.instanceInboundPermissionAuthorizations
    /**
     * A set of ports to remove from the container fleet's inbound permissions.
     */
    public val instanceInboundPermissionRevocations: List<IpPermission>? = builder.instanceInboundPermissionRevocations
    /**
     * The method for collecting container logs for the fleet.
     */
    public val logConfiguration: aws.sdk.kotlin.services.gamelift.model.LogConfiguration? = builder.logConfiguration
    /**
     * The name of an Amazon Web Services CloudWatch metric group to add this fleet to.
     */
    public val metricGroups: List<String>? = builder.metricGroups
    /**
     * The game session protection policy to apply to all new game sessions that are started in this fleet. Game sessions that already exist are not affected.
     */
    public val newGameSessionProtectionPolicy: aws.sdk.kotlin.services.gamelift.model.ProtectionPolicy? = builder.newGameSessionProtectionPolicy
    /**
     * The name or ARN value of a new per-instance container group definition to deploy on the fleet. If you're updating the fleet to a specific version of a container group definition, use the ARN value and include the version number. If you're updating the fleet to the latest version of a container group definition, you can use the name value.
     *
     * Update a container group definition by calling [UpdateContainerGroupDefinition](https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateContainerGroupDefinition.html). This operation creates a [ContainerGroupDefinition](https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html) resource with an incremented version.
     *
     * To remove a fleet's per-instance container group definition, leave this parameter empty and use the parameter `RemoveAttributes`.
     */
    public val perInstanceContainerGroupDefinitionName: kotlin.String? = builder.perInstanceContainerGroupDefinitionName
    /**
     * If set, this update removes a fleet's per-instance container group definition. You can't remove a fleet's game server container group definition.
     */
    public val removeAttributes: List<ContainerFleetRemoveAttribute>? = builder.removeAttributes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.UpdateContainerFleetRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateContainerFleetRequest(")
        append("deploymentConfiguration=$deploymentConfiguration,")
        append("description=$description,")
        append("fleetId=$fleetId,")
        append("gameServerContainerGroupDefinitionName=$gameServerContainerGroupDefinitionName,")
        append("gameServerContainerGroupsPerInstance=$gameServerContainerGroupsPerInstance,")
        append("gameSessionCreationLimitPolicy=$gameSessionCreationLimitPolicy,")
        append("instanceConnectionPortRange=$instanceConnectionPortRange,")
        append("instanceInboundPermissionAuthorizations=$instanceInboundPermissionAuthorizations,")
        append("instanceInboundPermissionRevocations=$instanceInboundPermissionRevocations,")
        append("logConfiguration=$logConfiguration,")
        append("metricGroups=$metricGroups,")
        append("newGameSessionProtectionPolicy=$newGameSessionProtectionPolicy,")
        append("perInstanceContainerGroupDefinitionName=$perInstanceContainerGroupDefinitionName,")
        append("removeAttributes=$removeAttributes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deploymentConfiguration?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (fleetId?.hashCode() ?: 0)
        result = 31 * result + (gameServerContainerGroupDefinitionName?.hashCode() ?: 0)
        result = 31 * result + (gameServerContainerGroupsPerInstance ?: 0)
        result = 31 * result + (gameSessionCreationLimitPolicy?.hashCode() ?: 0)
        result = 31 * result + (instanceConnectionPortRange?.hashCode() ?: 0)
        result = 31 * result + (instanceInboundPermissionAuthorizations?.hashCode() ?: 0)
        result = 31 * result + (instanceInboundPermissionRevocations?.hashCode() ?: 0)
        result = 31 * result + (logConfiguration?.hashCode() ?: 0)
        result = 31 * result + (metricGroups?.hashCode() ?: 0)
        result = 31 * result + (newGameSessionProtectionPolicy?.hashCode() ?: 0)
        result = 31 * result + (perInstanceContainerGroupDefinitionName?.hashCode() ?: 0)
        result = 31 * result + (removeAttributes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateContainerFleetRequest

        if (deploymentConfiguration != other.deploymentConfiguration) return false
        if (description != other.description) return false
        if (fleetId != other.fleetId) return false
        if (gameServerContainerGroupDefinitionName != other.gameServerContainerGroupDefinitionName) return false
        if (gameServerContainerGroupsPerInstance != other.gameServerContainerGroupsPerInstance) return false
        if (gameSessionCreationLimitPolicy != other.gameSessionCreationLimitPolicy) return false
        if (instanceConnectionPortRange != other.instanceConnectionPortRange) return false
        if (instanceInboundPermissionAuthorizations != other.instanceInboundPermissionAuthorizations) return false
        if (instanceInboundPermissionRevocations != other.instanceInboundPermissionRevocations) return false
        if (logConfiguration != other.logConfiguration) return false
        if (metricGroups != other.metricGroups) return false
        if (newGameSessionProtectionPolicy != other.newGameSessionProtectionPolicy) return false
        if (perInstanceContainerGroupDefinitionName != other.perInstanceContainerGroupDefinitionName) return false
        if (removeAttributes != other.removeAttributes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.UpdateContainerFleetRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Instructions for how to deploy updates to a container fleet, if the fleet update initiates a deployment. The deployment configuration lets you determine how to replace fleet instances and what actions to take if the deployment fails.
         */
        public var deploymentConfiguration: aws.sdk.kotlin.services.gamelift.model.DeploymentConfiguration? = null
        /**
         * A meaningful description of the container fleet.
         */
        public var description: kotlin.String? = null
        /**
         * A unique identifier for the container fleet to update. You can use either the fleet ID or ARN value.
         */
        public var fleetId: kotlin.String? = null
        /**
         * The name or ARN value of a new game server container group definition to deploy on the fleet. If you're updating the fleet to a specific version of a container group definition, use the ARN value and include the version number. If you're updating the fleet to the latest version of a container group definition, you can use the name value. You can't remove a fleet's game server container group definition, you can only update or replace it with another definition.
         *
         * Update a container group definition by calling [UpdateContainerGroupDefinition](https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateContainerGroupDefinition.html). This operation creates a [ContainerGroupDefinition](https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html) resource with an incremented version.
         */
        public var gameServerContainerGroupDefinitionName: kotlin.String? = null
        /**
         * The number of times to replicate the game server container group on each fleet instance. By default, Amazon GameLift Servers calculates the maximum number of game server container groups that can fit on each instance. You can remove this property value to use the calculated value, or set it manually. If you set this number manually, Amazon GameLift Servers uses your value as long as it's less than the calculated maximum.
         */
        public var gameServerContainerGroupsPerInstance: kotlin.Int? = null
        /**
         * A policy that limits the number of game sessions that each individual player can create on instances in this fleet. The limit applies for a specified span of time.
         */
        public var gameSessionCreationLimitPolicy: aws.sdk.kotlin.services.gamelift.model.GameSessionCreationLimitPolicy? = null
        /**
         * A revised set of port numbers to open on each fleet instance. By default, Amazon GameLift Servers calculates an optimal port range based on your fleet configuration. If you previously set this parameter manually, you can't reset this to use the calculated settings.
         */
        public var instanceConnectionPortRange: aws.sdk.kotlin.services.gamelift.model.ConnectionPortRange? = null
        /**
         * A set of ports to add to the container fleet's inbound permissions.
         */
        public var instanceInboundPermissionAuthorizations: List<IpPermission>? = null
        /**
         * A set of ports to remove from the container fleet's inbound permissions.
         */
        public var instanceInboundPermissionRevocations: List<IpPermission>? = null
        /**
         * The method for collecting container logs for the fleet.
         */
        public var logConfiguration: aws.sdk.kotlin.services.gamelift.model.LogConfiguration? = null
        /**
         * The name of an Amazon Web Services CloudWatch metric group to add this fleet to.
         */
        public var metricGroups: List<String>? = null
        /**
         * The game session protection policy to apply to all new game sessions that are started in this fleet. Game sessions that already exist are not affected.
         */
        public var newGameSessionProtectionPolicy: aws.sdk.kotlin.services.gamelift.model.ProtectionPolicy? = null
        /**
         * The name or ARN value of a new per-instance container group definition to deploy on the fleet. If you're updating the fleet to a specific version of a container group definition, use the ARN value and include the version number. If you're updating the fleet to the latest version of a container group definition, you can use the name value.
         *
         * Update a container group definition by calling [UpdateContainerGroupDefinition](https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateContainerGroupDefinition.html). This operation creates a [ContainerGroupDefinition](https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html) resource with an incremented version.
         *
         * To remove a fleet's per-instance container group definition, leave this parameter empty and use the parameter `RemoveAttributes`.
         */
        public var perInstanceContainerGroupDefinitionName: kotlin.String? = null
        /**
         * If set, this update removes a fleet's per-instance container group definition. You can't remove a fleet's game server container group definition.
         */
        public var removeAttributes: List<ContainerFleetRemoveAttribute>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.UpdateContainerFleetRequest) : this() {
            this.deploymentConfiguration = x.deploymentConfiguration
            this.description = x.description
            this.fleetId = x.fleetId
            this.gameServerContainerGroupDefinitionName = x.gameServerContainerGroupDefinitionName
            this.gameServerContainerGroupsPerInstance = x.gameServerContainerGroupsPerInstance
            this.gameSessionCreationLimitPolicy = x.gameSessionCreationLimitPolicy
            this.instanceConnectionPortRange = x.instanceConnectionPortRange
            this.instanceInboundPermissionAuthorizations = x.instanceInboundPermissionAuthorizations
            this.instanceInboundPermissionRevocations = x.instanceInboundPermissionRevocations
            this.logConfiguration = x.logConfiguration
            this.metricGroups = x.metricGroups
            this.newGameSessionProtectionPolicy = x.newGameSessionProtectionPolicy
            this.perInstanceContainerGroupDefinitionName = x.perInstanceContainerGroupDefinitionName
            this.removeAttributes = x.removeAttributes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.UpdateContainerFleetRequest = UpdateContainerFleetRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.DeploymentConfiguration] inside the given [block]
         */
        public fun deploymentConfiguration(block: aws.sdk.kotlin.services.gamelift.model.DeploymentConfiguration.Builder.() -> kotlin.Unit) {
            this.deploymentConfiguration = aws.sdk.kotlin.services.gamelift.model.DeploymentConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.GameSessionCreationLimitPolicy] inside the given [block]
         */
        public fun gameSessionCreationLimitPolicy(block: aws.sdk.kotlin.services.gamelift.model.GameSessionCreationLimitPolicy.Builder.() -> kotlin.Unit) {
            this.gameSessionCreationLimitPolicy = aws.sdk.kotlin.services.gamelift.model.GameSessionCreationLimitPolicy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.ConnectionPortRange] inside the given [block]
         */
        public fun instanceConnectionPortRange(block: aws.sdk.kotlin.services.gamelift.model.ConnectionPortRange.Builder.() -> kotlin.Unit) {
            this.instanceConnectionPortRange = aws.sdk.kotlin.services.gamelift.model.ConnectionPortRange.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.LogConfiguration] inside the given [block]
         */
        public fun logConfiguration(block: aws.sdk.kotlin.services.gamelift.model.LogConfiguration.Builder.() -> kotlin.Unit) {
            this.logConfiguration = aws.sdk.kotlin.services.gamelift.model.LogConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
