// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

public class TerminateGameSessionResponse private constructor(builder: Builder) {
    /**
     * Properties describing a game session.
     *
     * A game session in ACTIVE status can host players. When a game session ends, its status is set to `TERMINATED`.
     *
     * Amazon GameLift Servers retains a game session resource for 30 days after the game session ends. You can reuse idempotency token values after this time. Game session logs are retained for 14 days.
     *
     * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
     */
    public val gameSession: aws.sdk.kotlin.services.gamelift.model.GameSession? = builder.gameSession

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.TerminateGameSessionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TerminateGameSessionResponse(")
        append("gameSession=$gameSession")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = gameSession?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TerminateGameSessionResponse

        if (gameSession != other.gameSession) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.TerminateGameSessionResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Properties describing a game session.
         *
         * A game session in ACTIVE status can host players. When a game session ends, its status is set to `TERMINATED`.
         *
         * Amazon GameLift Servers retains a game session resource for 30 days after the game session ends. You can reuse idempotency token values after this time. Game session logs are retained for 14 days.
         *
         * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
         */
        public var gameSession: aws.sdk.kotlin.services.gamelift.model.GameSession? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.TerminateGameSessionResponse) : this() {
            this.gameSession = x.gameSession
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.TerminateGameSessionResponse = TerminateGameSessionResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.GameSession] inside the given [block]
         */
        public fun gameSession(block: aws.sdk.kotlin.services.gamelift.model.GameSession.Builder.() -> kotlin.Unit) {
            this.gameSession = aws.sdk.kotlin.services.gamelift.model.GameSession.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
