// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

public class TerminateGameSessionRequest private constructor(builder: Builder) {
    /**
     * A unique identifier for the game session to be terminated. A game session ARN has the following format: `arn:aws:gamelift:<location>::gamesession/<fleet ID>/<custom ID string or idempotency token>`.
     */
    public val gameSessionId: kotlin.String? = builder.gameSessionId
    /**
     * The method to use to terminate the game session. Available methods include:
     * + `TRIGGER_ON_PROCESS_TERMINATE` – Prompts the Amazon GameLift Servers service to send an `OnProcessTerminate()` callback to the server process and initiate the normal game session shutdown sequence. The `OnProcessTerminate` method, which is implemented in the game server code, must include a call to the server SDK action `ProcessEnding()`, which is how the server process signals to Amazon GameLift Servers that a game session is ending. If the server process doesn't call `ProcessEnding()`, the game session termination won't conclude successfully.
     * + `FORCE_TERMINATE` – Prompts the Amazon GameLift Servers service to stop the server process immediately. Amazon GameLift Servers takes action (depending on the type of fleet) to shut down the server process without the normal game session shutdown sequence. This method is not available for game sessions that are running on Anywhere fleets unless the fleet is deployed with the Amazon GameLift Servers Agent. In this scenario, a force terminate request results in an invalid or bad request exception.
     */
    public val terminationMode: aws.sdk.kotlin.services.gamelift.model.TerminationMode? = builder.terminationMode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.TerminateGameSessionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TerminateGameSessionRequest(")
        append("gameSessionId=$gameSessionId,")
        append("terminationMode=$terminationMode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = gameSessionId?.hashCode() ?: 0
        result = 31 * result + (terminationMode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TerminateGameSessionRequest

        if (gameSessionId != other.gameSessionId) return false
        if (terminationMode != other.terminationMode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.TerminateGameSessionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique identifier for the game session to be terminated. A game session ARN has the following format: `arn:aws:gamelift:<location>::gamesession/<fleet ID>/<custom ID string or idempotency token>`.
         */
        public var gameSessionId: kotlin.String? = null
        /**
         * The method to use to terminate the game session. Available methods include:
         * + `TRIGGER_ON_PROCESS_TERMINATE` – Prompts the Amazon GameLift Servers service to send an `OnProcessTerminate()` callback to the server process and initiate the normal game session shutdown sequence. The `OnProcessTerminate` method, which is implemented in the game server code, must include a call to the server SDK action `ProcessEnding()`, which is how the server process signals to Amazon GameLift Servers that a game session is ending. If the server process doesn't call `ProcessEnding()`, the game session termination won't conclude successfully.
         * + `FORCE_TERMINATE` – Prompts the Amazon GameLift Servers service to stop the server process immediately. Amazon GameLift Servers takes action (depending on the type of fleet) to shut down the server process without the normal game session shutdown sequence. This method is not available for game sessions that are running on Anywhere fleets unless the fleet is deployed with the Amazon GameLift Servers Agent. In this scenario, a force terminate request results in an invalid or bad request exception.
         */
        public var terminationMode: aws.sdk.kotlin.services.gamelift.model.TerminationMode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.TerminateGameSessionRequest) : this() {
            this.gameSessionId = x.gameSessionId
            this.terminationMode = x.terminationMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.TerminateGameSessionRequest = TerminateGameSessionRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
