// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * **This data type is used with the Amazon GameLift Servers FleetIQ and game server groups.**
 *
 * Settings for a target-based scaling policy as part of a [GameServerGroupAutoScalingPolicy](https://docs.aws.amazon.com/gamelift/latest/apireference/API_GameServerGroupAutoScalingPolicy.html) . These settings are used to create a target-based policy that tracks the Amazon GameLift Servers FleetIQ metric `"PercentUtilizedGameServers"` and specifies a target value for the metric. As player usage changes, the policy triggers to adjust the game server group capacity so that the metric returns to the target value.
 */
public class TargetTrackingConfiguration private constructor(builder: Builder) {
    /**
     * Desired value to use with a game server group target-based scaling policy.
     */
    public val targetValue: kotlin.Double? = builder.targetValue

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.TargetTrackingConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TargetTrackingConfiguration(")
        append("targetValue=$targetValue")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = targetValue?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TargetTrackingConfiguration

        if (!(targetValue?.equals(other.targetValue) ?: (other.targetValue == null))) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.TargetTrackingConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Desired value to use with a game server group target-based scaling policy.
         */
        public var targetValue: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.TargetTrackingConfiguration) : this() {
            this.targetValue = x.targetValue
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.TargetTrackingConfiguration = TargetTrackingConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
