// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes a support container in a container group. You can define a support container in either a game server container group or a per-instance container group. Support containers don't run game server processes.
 *
 * This definition includes container configuration, resources, and start instructions. Use this data type when creating or updating a container group definition. For properties of a deployed support container, see [SupportContainerDefinition](https://docs.aws.amazon.com/gamelift/latest/apireference/API_SupportContainerDefinition.html).
 *
 * **Use with: **[CreateContainerGroupDefinition](https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateContainerGroupDefinition.html), [UpdateContainerGroupDefinition](https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateContainerGroupDefinition.html)
 */
public class SupportContainerDefinitionInput private constructor(builder: Builder) {
    /**
     * A string that uniquely identifies the container definition within a container group.
     */
    public val containerName: kotlin.String? = builder.containerName
    /**
     * Establishes dependencies between this container and the status of other containers in the same container group. A container can have dependencies on multiple different containers.
     *
     * .
     *
     * You can use dependencies to establish a startup/shutdown sequence across the container group. For example, you might specify that *ContainerB* has a `START` dependency on *ContainerA*. This dependency means that *ContainerB* can't start until after *ContainerA* has started. This dependency is reversed on shutdown, which means that *ContainerB* must shut down before *ContainerA* can shut down.
     */
    public val dependsOn: List<ContainerDependency>? = builder.dependsOn
    /**
     * A set of environment variables to pass to the container on startup. See the [ContainerDefinition::environment](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDefinition.html#ECS-Type-ContainerDefinition-environment) parameter in the *Amazon Elastic Container Service API Reference*.
     */
    public val environmentOverride: List<ContainerEnvironment>? = builder.environmentOverride
    /**
     * Flags the container as vital for the container group to function properly. If an essential container fails, the entire container group restarts. At least one support container in a per-instance container group must be essential. When flagging a container as essential, also configure a health check so that the container can signal that it's healthy.
     */
    public val essential: kotlin.Boolean? = builder.essential
    /**
     * Configuration for a non-terminal health check. A container automatically restarts if it stops functioning. With a health check, you can define additional reasons to flag a container as unhealthy and restart it. If an essential container fails a health check, the entire container group restarts.
     */
    public val healthCheck: aws.sdk.kotlin.services.gamelift.model.ContainerHealthCheck? = builder.healthCheck
    /**
     * The location of the container image to deploy to a container fleet. Provide an image in an Amazon Elastic Container Registry public or private repository. The repository must be in the same Amazon Web Services account and Amazon Web Services Region where you're creating the container group definition. For limits on image size, see [Amazon GameLift Servers endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/gamelift.html). You can use any of the following image URI formats:
     * + Image ID only: `[AWS account].dkr.ecr.[AWS region].amazonaws.com/[repository ID]`
     * + Image ID and digest: `[AWS account].dkr.ecr.[AWS region].amazonaws.com/[repository ID]@[digest]`
     * + Image ID and tag: `[AWS account].dkr.ecr.[AWS region].amazonaws.com/[repository ID]:[tag]`
     */
    public val imageUri: kotlin.String? = builder.imageUri
    /**
     * A specified amount of memory (in MiB) to reserve for this container. If you don't specify a container-specific memory limit, the container shares the container group's total memory allocation.
     *
     * **Related data type: **[ContainerGroupDefinition](https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html)TotalMemoryLimitMebibytes``
     */
    public val memoryHardLimitMebibytes: kotlin.Int? = builder.memoryHardLimitMebibytes
    /**
     * A mount point that binds a path inside the container to a file or directory on the host system and lets it access the file or directory.
     */
    public val mountPoints: List<ContainerMountPoint>? = builder.mountPoints
    /**
     * A set of ports that Amazon GameLift Servers can assign to processes in a container. The container port configuration must have enough ports for each container process that accepts inbound traffic connections. A container port configuration can have can have one or more container port ranges. Each range specifies starting and ending values as well as the supported network protocol.
     *
     * Container ports aren't directly accessed by inbound traffic. Amazon GameLift Servers maps each container port to an externally accessible connection port (see the container fleet property `ConnectionPortRange`).
     */
    public val portConfiguration: aws.sdk.kotlin.services.gamelift.model.ContainerPortConfiguration? = builder.portConfiguration
    /**
     * The number of vCPU units to reserve for this container. The container can use more resources when needed, if available. If you don't reserve CPU units for this container, it shares the container group's total vCPU limit.
     *
     * **Related data type: **[ContainerGroupDefinition](https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html) TotalCpuLimit
     */
    public val vcpu: kotlin.Double? = builder.vcpu

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.SupportContainerDefinitionInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SupportContainerDefinitionInput(")
        append("containerName=$containerName,")
        append("dependsOn=$dependsOn,")
        append("environmentOverride=$environmentOverride,")
        append("essential=$essential,")
        append("healthCheck=$healthCheck,")
        append("imageUri=$imageUri,")
        append("memoryHardLimitMebibytes=$memoryHardLimitMebibytes,")
        append("mountPoints=$mountPoints,")
        append("portConfiguration=$portConfiguration,")
        append("vcpu=$vcpu")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerName?.hashCode() ?: 0
        result = 31 * result + (dependsOn?.hashCode() ?: 0)
        result = 31 * result + (environmentOverride?.hashCode() ?: 0)
        result = 31 * result + (essential?.hashCode() ?: 0)
        result = 31 * result + (healthCheck?.hashCode() ?: 0)
        result = 31 * result + (imageUri?.hashCode() ?: 0)
        result = 31 * result + (memoryHardLimitMebibytes ?: 0)
        result = 31 * result + (mountPoints?.hashCode() ?: 0)
        result = 31 * result + (portConfiguration?.hashCode() ?: 0)
        result = 31 * result + (vcpu?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SupportContainerDefinitionInput

        if (containerName != other.containerName) return false
        if (dependsOn != other.dependsOn) return false
        if (environmentOverride != other.environmentOverride) return false
        if (essential != other.essential) return false
        if (healthCheck != other.healthCheck) return false
        if (imageUri != other.imageUri) return false
        if (memoryHardLimitMebibytes != other.memoryHardLimitMebibytes) return false
        if (mountPoints != other.mountPoints) return false
        if (portConfiguration != other.portConfiguration) return false
        if (!(vcpu?.equals(other.vcpu) ?: (other.vcpu == null))) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.SupportContainerDefinitionInput = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A string that uniquely identifies the container definition within a container group.
         */
        public var containerName: kotlin.String? = null
        /**
         * Establishes dependencies between this container and the status of other containers in the same container group. A container can have dependencies on multiple different containers.
         *
         * .
         *
         * You can use dependencies to establish a startup/shutdown sequence across the container group. For example, you might specify that *ContainerB* has a `START` dependency on *ContainerA*. This dependency means that *ContainerB* can't start until after *ContainerA* has started. This dependency is reversed on shutdown, which means that *ContainerB* must shut down before *ContainerA* can shut down.
         */
        public var dependsOn: List<ContainerDependency>? = null
        /**
         * A set of environment variables to pass to the container on startup. See the [ContainerDefinition::environment](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDefinition.html#ECS-Type-ContainerDefinition-environment) parameter in the *Amazon Elastic Container Service API Reference*.
         */
        public var environmentOverride: List<ContainerEnvironment>? = null
        /**
         * Flags the container as vital for the container group to function properly. If an essential container fails, the entire container group restarts. At least one support container in a per-instance container group must be essential. When flagging a container as essential, also configure a health check so that the container can signal that it's healthy.
         */
        public var essential: kotlin.Boolean? = null
        /**
         * Configuration for a non-terminal health check. A container automatically restarts if it stops functioning. With a health check, you can define additional reasons to flag a container as unhealthy and restart it. If an essential container fails a health check, the entire container group restarts.
         */
        public var healthCheck: aws.sdk.kotlin.services.gamelift.model.ContainerHealthCheck? = null
        /**
         * The location of the container image to deploy to a container fleet. Provide an image in an Amazon Elastic Container Registry public or private repository. The repository must be in the same Amazon Web Services account and Amazon Web Services Region where you're creating the container group definition. For limits on image size, see [Amazon GameLift Servers endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/gamelift.html). You can use any of the following image URI formats:
         * + Image ID only: `[AWS account].dkr.ecr.[AWS region].amazonaws.com/[repository ID]`
         * + Image ID and digest: `[AWS account].dkr.ecr.[AWS region].amazonaws.com/[repository ID]@[digest]`
         * + Image ID and tag: `[AWS account].dkr.ecr.[AWS region].amazonaws.com/[repository ID]:[tag]`
         */
        public var imageUri: kotlin.String? = null
        /**
         * A specified amount of memory (in MiB) to reserve for this container. If you don't specify a container-specific memory limit, the container shares the container group's total memory allocation.
         *
         * **Related data type: **[ContainerGroupDefinition](https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html)TotalMemoryLimitMebibytes``
         */
        public var memoryHardLimitMebibytes: kotlin.Int? = null
        /**
         * A mount point that binds a path inside the container to a file or directory on the host system and lets it access the file or directory.
         */
        public var mountPoints: List<ContainerMountPoint>? = null
        /**
         * A set of ports that Amazon GameLift Servers can assign to processes in a container. The container port configuration must have enough ports for each container process that accepts inbound traffic connections. A container port configuration can have can have one or more container port ranges. Each range specifies starting and ending values as well as the supported network protocol.
         *
         * Container ports aren't directly accessed by inbound traffic. Amazon GameLift Servers maps each container port to an externally accessible connection port (see the container fleet property `ConnectionPortRange`).
         */
        public var portConfiguration: aws.sdk.kotlin.services.gamelift.model.ContainerPortConfiguration? = null
        /**
         * The number of vCPU units to reserve for this container. The container can use more resources when needed, if available. If you don't reserve CPU units for this container, it shares the container group's total vCPU limit.
         *
         * **Related data type: **[ContainerGroupDefinition](https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html) TotalCpuLimit
         */
        public var vcpu: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.SupportContainerDefinitionInput) : this() {
            this.containerName = x.containerName
            this.dependsOn = x.dependsOn
            this.environmentOverride = x.environmentOverride
            this.essential = x.essential
            this.healthCheck = x.healthCheck
            this.imageUri = x.imageUri
            this.memoryHardLimitMebibytes = x.memoryHardLimitMebibytes
            this.mountPoints = x.mountPoints
            this.portConfiguration = x.portConfiguration
            this.vcpu = x.vcpu
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.SupportContainerDefinitionInput = SupportContainerDefinitionInput(this)

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.ContainerHealthCheck] inside the given [block]
         */
        public fun healthCheck(block: aws.sdk.kotlin.services.gamelift.model.ContainerHealthCheck.Builder.() -> kotlin.Unit) {
            this.healthCheck = aws.sdk.kotlin.services.gamelift.model.ContainerHealthCheck.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.ContainerPortConfiguration] inside the given [block]
         */
        public fun portConfiguration(block: aws.sdk.kotlin.services.gamelift.model.ContainerPortConfiguration.Builder.() -> kotlin.Unit) {
            this.portConfiguration = aws.sdk.kotlin.services.gamelift.model.ContainerPortConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
