// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

public class StartGameSessionPlacementRequest private constructor(builder: Builder) {
    /**
     * Set of information on each player to create a player session for.
     */
    public val desiredPlayerSessions: List<DesiredPlayerSession>? = builder.desiredPlayerSessions
    /**
     * A set of key-value pairs that can store custom data in a game session. For example: `{"Key": "difficulty", "Value": "novice"}`.
     */
    public val gameProperties: List<GameProperty>? = builder.gameProperties
    /**
     * A set of custom game session properties, formatted as a single string value. This data is passed to a game server process with a request to start a new game session. For more information, see [Start a game session](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession).
     */
    public val gameSessionData: kotlin.String? = builder.gameSessionData
    /**
     * A descriptive label that is associated with a game session. Session names do not need to be unique.
     */
    public val gameSessionName: kotlin.String? = builder.gameSessionName
    /**
     * Name of the queue to use to place the new game session. You can use either the queue name or ARN value.
     */
    public val gameSessionQueueName: kotlin.String? = builder.gameSessionQueueName
    /**
     * The maximum number of players that can be connected simultaneously to the game session.
     */
    public val maximumPlayerSessionCount: kotlin.Int? = builder.maximumPlayerSessionCount
    /**
     * A unique identifier to assign to the new game session placement. This value is developer-defined. The value must be unique across all Regions and cannot be reused.
     */
    public val placementId: kotlin.String? = builder.placementId
    /**
     * A set of values, expressed in milliseconds, that indicates the amount of latency that a player experiences when connected to Amazon Web Services Regions. This information is used to try to place the new game session where it can offer the best possible gameplay experience for the players.
     */
    public val playerLatencies: List<PlayerLatency>? = builder.playerLatencies
    /**
     * A prioritized list of locations to use for the game session placement and instructions on how to use it. This list overrides a queue's prioritized location list for this game session placement request only. You can include Amazon Web Services Regions, local zones, and custom locations (for Anywhere fleets). You can choose to limit placements to locations on the override list only, or you can prioritize locations on the override list first and then fall back to the queue's other locations if needed. Choose a fallback strategy to use in the event that Amazon GameLift Servers fails to place a game session in any of the locations on the priority override list.
     */
    public val priorityConfigurationOverride: aws.sdk.kotlin.services.gamelift.model.PriorityConfigurationOverride? = builder.priorityConfigurationOverride

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.StartGameSessionPlacementRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartGameSessionPlacementRequest(")
        append("desiredPlayerSessions=$desiredPlayerSessions,")
        append("gameProperties=$gameProperties,")
        append("gameSessionData=$gameSessionData,")
        append("gameSessionName=$gameSessionName,")
        append("gameSessionQueueName=$gameSessionQueueName,")
        append("maximumPlayerSessionCount=$maximumPlayerSessionCount,")
        append("placementId=$placementId,")
        append("playerLatencies=$playerLatencies,")
        append("priorityConfigurationOverride=$priorityConfigurationOverride")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = desiredPlayerSessions?.hashCode() ?: 0
        result = 31 * result + (gameProperties?.hashCode() ?: 0)
        result = 31 * result + (gameSessionData?.hashCode() ?: 0)
        result = 31 * result + (gameSessionName?.hashCode() ?: 0)
        result = 31 * result + (gameSessionQueueName?.hashCode() ?: 0)
        result = 31 * result + (maximumPlayerSessionCount ?: 0)
        result = 31 * result + (placementId?.hashCode() ?: 0)
        result = 31 * result + (playerLatencies?.hashCode() ?: 0)
        result = 31 * result + (priorityConfigurationOverride?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartGameSessionPlacementRequest

        if (desiredPlayerSessions != other.desiredPlayerSessions) return false
        if (gameProperties != other.gameProperties) return false
        if (gameSessionData != other.gameSessionData) return false
        if (gameSessionName != other.gameSessionName) return false
        if (gameSessionQueueName != other.gameSessionQueueName) return false
        if (maximumPlayerSessionCount != other.maximumPlayerSessionCount) return false
        if (placementId != other.placementId) return false
        if (playerLatencies != other.playerLatencies) return false
        if (priorityConfigurationOverride != other.priorityConfigurationOverride) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.StartGameSessionPlacementRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Set of information on each player to create a player session for.
         */
        public var desiredPlayerSessions: List<DesiredPlayerSession>? = null
        /**
         * A set of key-value pairs that can store custom data in a game session. For example: `{"Key": "difficulty", "Value": "novice"}`.
         */
        public var gameProperties: List<GameProperty>? = null
        /**
         * A set of custom game session properties, formatted as a single string value. This data is passed to a game server process with a request to start a new game session. For more information, see [Start a game session](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession).
         */
        public var gameSessionData: kotlin.String? = null
        /**
         * A descriptive label that is associated with a game session. Session names do not need to be unique.
         */
        public var gameSessionName: kotlin.String? = null
        /**
         * Name of the queue to use to place the new game session. You can use either the queue name or ARN value.
         */
        public var gameSessionQueueName: kotlin.String? = null
        /**
         * The maximum number of players that can be connected simultaneously to the game session.
         */
        public var maximumPlayerSessionCount: kotlin.Int? = null
        /**
         * A unique identifier to assign to the new game session placement. This value is developer-defined. The value must be unique across all Regions and cannot be reused.
         */
        public var placementId: kotlin.String? = null
        /**
         * A set of values, expressed in milliseconds, that indicates the amount of latency that a player experiences when connected to Amazon Web Services Regions. This information is used to try to place the new game session where it can offer the best possible gameplay experience for the players.
         */
        public var playerLatencies: List<PlayerLatency>? = null
        /**
         * A prioritized list of locations to use for the game session placement and instructions on how to use it. This list overrides a queue's prioritized location list for this game session placement request only. You can include Amazon Web Services Regions, local zones, and custom locations (for Anywhere fleets). You can choose to limit placements to locations on the override list only, or you can prioritize locations on the override list first and then fall back to the queue's other locations if needed. Choose a fallback strategy to use in the event that Amazon GameLift Servers fails to place a game session in any of the locations on the priority override list.
         */
        public var priorityConfigurationOverride: aws.sdk.kotlin.services.gamelift.model.PriorityConfigurationOverride? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.StartGameSessionPlacementRequest) : this() {
            this.desiredPlayerSessions = x.desiredPlayerSessions
            this.gameProperties = x.gameProperties
            this.gameSessionData = x.gameSessionData
            this.gameSessionName = x.gameSessionName
            this.gameSessionQueueName = x.gameSessionQueueName
            this.maximumPlayerSessionCount = x.maximumPlayerSessionCount
            this.placementId = x.placementId
            this.playerLatencies = x.playerLatencies
            this.priorityConfigurationOverride = x.priorityConfigurationOverride
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.StartGameSessionPlacementRequest = StartGameSessionPlacementRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.PriorityConfigurationOverride] inside the given [block]
         */
        public fun priorityConfigurationOverride(block: aws.sdk.kotlin.services.gamelift.model.PriorityConfigurationOverride.Builder.() -> kotlin.Unit) {
            this.priorityConfigurationOverride = aws.sdk.kotlin.services.gamelift.model.PriorityConfigurationOverride.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
