// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The location in Amazon S3 where build or script files are stored for access by Amazon GameLift Servers.
 */
public class S3Location private constructor(builder: Builder) {
    /**
     * An Amazon S3 bucket identifier. Thename of the S3 bucket.
     *
     * Amazon GameLift Servers doesn't support uploading from Amazon S3 buckets with names that contain a dot (.).
     */
    public val bucket: kotlin.String? = builder.bucket
    /**
     * The name of the zip file that contains the build files or script files.
     */
    public val key: kotlin.String? = builder.key
    /**
     * The version of the file, if object versioning is turned on for the bucket. Amazon GameLift Servers uses this information when retrieving files from an S3 bucket that you own. Use this parameter to specify a specific version of the file. If not set, the latest version of the file is retrieved.
     */
    public val objectVersion: kotlin.String? = builder.objectVersion
    /**
     * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) for an IAM role that allows Amazon GameLift Servers to access the S3 bucket.
     */
    public val roleArn: kotlin.String? = builder.roleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.S3Location = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3Location(")
        append("bucket=$bucket,")
        append("key=$key,")
        append("objectVersion=$objectVersion,")
        append("roleArn=$roleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (objectVersion?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3Location

        if (bucket != other.bucket) return false
        if (key != other.key) return false
        if (objectVersion != other.objectVersion) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.S3Location = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An Amazon S3 bucket identifier. Thename of the S3 bucket.
         *
         * Amazon GameLift Servers doesn't support uploading from Amazon S3 buckets with names that contain a dot (.).
         */
        public var bucket: kotlin.String? = null
        /**
         * The name of the zip file that contains the build files or script files.
         */
        public var key: kotlin.String? = null
        /**
         * The version of the file, if object versioning is turned on for the bucket. Amazon GameLift Servers uses this information when retrieving files from an S3 bucket that you own. Use this parameter to specify a specific version of the file. If not set, the latest version of the file is retrieved.
         */
        public var objectVersion: kotlin.String? = null
        /**
         * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) for an IAM role that allows Amazon GameLift Servers to access the S3 bucket.
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.S3Location) : this() {
            this.bucket = x.bucket
            this.key = x.key
            this.objectVersion = x.objectVersion
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.S3Location = S3Location(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
