// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A set of instructions that define the set of server processes to run on computes in a fleet. Server processes run either an executable in a custom game build or a Amazon GameLift Servers Realtime script. Amazon GameLift Servers launches the processes, manages their life cycle, and replaces them as needed. Computes check regularly for an updated runtime configuration.
 *
 * An Amazon GameLift Servers instance is limited to 50 processes running concurrently. To calculate the total number of processes defined in a runtime configuration, add the values of the `ConcurrentExecutions` parameter for each server process. Learn more about [ Running Multiple Processes on a Fleet](https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-multiprocess.html).
 */
public class RuntimeConfiguration private constructor(builder: Builder) {
    /**
     * The maximum amount of time (in seconds) allowed to launch a new game session and have it report ready to host players. During this time, the game session is in status `ACTIVATING`. If the game session does not become active before the timeout, it is ended and the game session status is changed to `TERMINATED`.
     */
    public val gameSessionActivationTimeoutSeconds: kotlin.Int? = builder.gameSessionActivationTimeoutSeconds
    /**
     * The number of game sessions in status `ACTIVATING` to allow on an instance or compute. This setting limits the instance resources that can be used for new game activations at any one time.
     */
    public val maxConcurrentGameSessionActivations: kotlin.Int? = builder.maxConcurrentGameSessionActivations
    /**
     * A collection of server process configurations that identify what server processes to run on fleet computes.
     */
    public val serverProcesses: List<ServerProcess>? = builder.serverProcesses

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.RuntimeConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RuntimeConfiguration(")
        append("gameSessionActivationTimeoutSeconds=$gameSessionActivationTimeoutSeconds,")
        append("maxConcurrentGameSessionActivations=$maxConcurrentGameSessionActivations,")
        append("serverProcesses=$serverProcesses")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = gameSessionActivationTimeoutSeconds ?: 0
        result = 31 * result + (maxConcurrentGameSessionActivations ?: 0)
        result = 31 * result + (serverProcesses?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RuntimeConfiguration

        if (gameSessionActivationTimeoutSeconds != other.gameSessionActivationTimeoutSeconds) return false
        if (maxConcurrentGameSessionActivations != other.maxConcurrentGameSessionActivations) return false
        if (serverProcesses != other.serverProcesses) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.RuntimeConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The maximum amount of time (in seconds) allowed to launch a new game session and have it report ready to host players. During this time, the game session is in status `ACTIVATING`. If the game session does not become active before the timeout, it is ended and the game session status is changed to `TERMINATED`.
         */
        public var gameSessionActivationTimeoutSeconds: kotlin.Int? = null
        /**
         * The number of game sessions in status `ACTIVATING` to allow on an instance or compute. This setting limits the instance resources that can be used for new game activations at any one time.
         */
        public var maxConcurrentGameSessionActivations: kotlin.Int? = null
        /**
         * A collection of server process configurations that identify what server processes to run on fleet computes.
         */
        public var serverProcesses: List<ServerProcess>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.RuntimeConfiguration) : this() {
            this.gameSessionActivationTimeoutSeconds = x.gameSessionActivationTimeoutSeconds
            this.maxConcurrentGameSessionActivations = x.maxConcurrentGameSessionActivations
            this.serverProcesses = x.serverProcesses
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.RuntimeConfiguration = RuntimeConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
