// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The routing configuration for a fleet alias.
 *
 * **Related actions**
 *
 * [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
 */
public class RoutingStrategy private constructor(builder: Builder) {
    /**
     * A unique identifier for the fleet that the alias points to. This value is the fleet ID, not the fleet ARN.
     */
    public val fleetId: kotlin.String? = builder.fleetId
    /**
     * The message text to be used with a terminal routing strategy.
     */
    public val message: kotlin.String? = builder.message
    /**
     * The type of routing strategy for the alias.
     *
     * Possible routing types include the following:
     * + **SIMPLE** - The alias resolves to one specific fleet. Use this type when routing to active fleets.
     * + **TERMINAL** - The alias does not resolve to a fleet but instead can be used to display a message to the user. A terminal alias throws a TerminalRoutingStrategyException with the message embedded.
     */
    public val type: aws.sdk.kotlin.services.gamelift.model.RoutingStrategyType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.RoutingStrategy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RoutingStrategy(")
        append("fleetId=$fleetId,")
        append("message=$message,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fleetId?.hashCode() ?: 0
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RoutingStrategy

        if (fleetId != other.fleetId) return false
        if (message != other.message) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.RoutingStrategy = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique identifier for the fleet that the alias points to. This value is the fleet ID, not the fleet ARN.
         */
        public var fleetId: kotlin.String? = null
        /**
         * The message text to be used with a terminal routing strategy.
         */
        public var message: kotlin.String? = null
        /**
         * The type of routing strategy for the alias.
         *
         * Possible routing types include the following:
         * + **SIMPLE** - The alias resolves to one specific fleet. Use this type when routing to active fleets.
         * + **TERMINAL** - The alias does not resolve to a fleet but instead can be used to display a message to the user. A terminal alias throws a TerminalRoutingStrategyException with the message embedded.
         */
        public var type: aws.sdk.kotlin.services.gamelift.model.RoutingStrategyType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.RoutingStrategy) : this() {
            this.fleetId = x.fleetId
            this.message = x.message
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.RoutingStrategy = RoutingStrategy(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
