// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An alternate list of prioritized locations for use with a game session queue. When this property is included in a [StartGameSessionPlacement](https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartGameSessionPlacement.html) request, the alternate list overrides the queue's default location priorities, as defined in the queue's [PriorityConfiguration](gamelift/latest/apireference/API_PriorityConfiguration.html) setting (*LocationOrder*). The override is valid for an individual placement request only. Use this property only with queues that have a `PriorityConfiguration` setting that prioritizes `LOCATION` first.
 *
 * A priority configuration override list does not override a queue's FilterConfiguration setting, if the queue has one. Filter configurations are used to limit placements to a subset of the locations in a queue's destinations. If the override list includes a location that's not on in the `FilterConfiguration` allowed list, Amazon GameLift Servers won't attempt to place a game session there.
 */
public class PriorityConfigurationOverride private constructor(builder: Builder) {
    /**
     * A prioritized list of hosting locations. The list can include Amazon Web Services Regions (such as `us-west-2`), local zones, and custom locations (for Anywhere fleets). Each location must be listed only once. For details, see [Amazon GameLift Servers service locations.](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html)
     */
    public val locationOrder: List<String>? = builder.locationOrder
    /**
     * Instructions for how to proceed if placement fails in every location on the priority override list. Valid strategies include:
     * + `DEFAULT_AFTER_SINGLE_PASS` -- After attempting to place a new game session in every location on the priority override list, try to place a game session in queue's other locations. This is the default behavior.
     * + `NONE` -- Limit placements to locations on the priority override list only.
     */
    public val placementFallbackStrategy: aws.sdk.kotlin.services.gamelift.model.PlacementFallbackStrategy? = builder.placementFallbackStrategy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.PriorityConfigurationOverride = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PriorityConfigurationOverride(")
        append("locationOrder=$locationOrder,")
        append("placementFallbackStrategy=$placementFallbackStrategy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = locationOrder?.hashCode() ?: 0
        result = 31 * result + (placementFallbackStrategy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PriorityConfigurationOverride

        if (locationOrder != other.locationOrder) return false
        if (placementFallbackStrategy != other.placementFallbackStrategy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.PriorityConfigurationOverride = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A prioritized list of hosting locations. The list can include Amazon Web Services Regions (such as `us-west-2`), local zones, and custom locations (for Anywhere fleets). Each location must be listed only once. For details, see [Amazon GameLift Servers service locations.](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html)
         */
        public var locationOrder: List<String>? = null
        /**
         * Instructions for how to proceed if placement fails in every location on the priority override list. Valid strategies include:
         * + `DEFAULT_AFTER_SINGLE_PASS` -- After attempting to place a new game session in every location on the priority override list, try to place a game session in queue's other locations. This is the default behavior.
         * + `NONE` -- Limit placements to locations on the priority override list only.
         */
        public var placementFallbackStrategy: aws.sdk.kotlin.services.gamelift.model.PlacementFallbackStrategy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.PriorityConfigurationOverride) : this() {
            this.locationOrder = x.locationOrder
            this.placementFallbackStrategy = x.placementFallbackStrategy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.PriorityConfigurationOverride = PriorityConfigurationOverride(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
