// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Sets a latency cap for individual players when placing a game session. With a latency policy in force, a game session cannot be placed in a fleet location where a player reports latency higher than the cap. Latency policies are used only with placement request that provide player latency information. Player latency policies can be stacked to gradually relax latency requirements over time.
 */
public class PlayerLatencyPolicy private constructor(builder: Builder) {
    /**
     * The maximum latency value that is allowed for any player, in milliseconds. All policies must have a value set for this property.
     */
    public val maximumIndividualPlayerLatencyMilliseconds: kotlin.Int? = builder.maximumIndividualPlayerLatencyMilliseconds
    /**
     * The length of time, in seconds, that the policy is enforced while placing a new game session. A null value for this property means that the policy is enforced until the queue times out.
     */
    public val policyDurationSeconds: kotlin.Int? = builder.policyDurationSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.PlayerLatencyPolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PlayerLatencyPolicy(")
        append("maximumIndividualPlayerLatencyMilliseconds=$maximumIndividualPlayerLatencyMilliseconds,")
        append("policyDurationSeconds=$policyDurationSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maximumIndividualPlayerLatencyMilliseconds ?: 0
        result = 31 * result + (policyDurationSeconds ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PlayerLatencyPolicy

        if (maximumIndividualPlayerLatencyMilliseconds != other.maximumIndividualPlayerLatencyMilliseconds) return false
        if (policyDurationSeconds != other.policyDurationSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.PlayerLatencyPolicy = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The maximum latency value that is allowed for any player, in milliseconds. All policies must have a value set for this property.
         */
        public var maximumIndividualPlayerLatencyMilliseconds: kotlin.Int? = null
        /**
         * The length of time, in seconds, that the policy is enforced while placing a new game session. A null value for this property means that the policy is enforced until the queue times out.
         */
        public var policyDurationSeconds: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.PlayerLatencyPolicy) : this() {
            this.maximumIndividualPlayerLatencyMilliseconds = x.maximumIndividualPlayerLatencyMilliseconds
            this.policyDurationSeconds = x.policyDurationSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.PlayerLatencyPolicy = PlayerLatencyPolicy(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
