// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Properties of a location, which can include its name, ARN (for custom locations), and ping beacon information.
 */
public class LocationModel private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is assigned to a custom location resource and uniquely identifies it. ARNs are unique across all Regions. Format is `arn:aws:gamelift:<region>::location/location-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912`.
     */
    public val locationArn: kotlin.String? = builder.locationArn
    /**
     * The location's name.
     */
    public val locationName: kotlin.String? = builder.locationName
    /**
     * Information about the UDP ping beacon for this location.
     */
    public val pingBeacon: aws.sdk.kotlin.services.gamelift.model.PingBeacon? = builder.pingBeacon

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.LocationModel = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LocationModel(")
        append("locationArn=$locationArn,")
        append("locationName=$locationName,")
        append("pingBeacon=$pingBeacon")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = locationArn?.hashCode() ?: 0
        result = 31 * result + (locationName?.hashCode() ?: 0)
        result = 31 * result + (pingBeacon?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LocationModel

        if (locationArn != other.locationArn) return false
        if (locationName != other.locationName) return false
        if (pingBeacon != other.pingBeacon) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.LocationModel = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is assigned to a custom location resource and uniquely identifies it. ARNs are unique across all Regions. Format is `arn:aws:gamelift:<region>::location/location-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912`.
         */
        public var locationArn: kotlin.String? = null
        /**
         * The location's name.
         */
        public var locationName: kotlin.String? = null
        /**
         * Information about the UDP ping beacon for this location.
         */
        public var pingBeacon: aws.sdk.kotlin.services.gamelift.model.PingBeacon? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.LocationModel) : this() {
            this.locationArn = x.locationArn
            this.locationName = x.locationName
            this.pingBeacon = x.pingBeacon
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.LocationModel = LocationModel(this)

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.PingBeacon] inside the given [block]
         */
        public fun pingBeacon(block: aws.sdk.kotlin.services.gamelift.model.PingBeacon.Builder.() -> kotlin.Unit) {
            this.pingBeacon = aws.sdk.kotlin.services.gamelift.model.PingBeacon.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
