// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListComputeRequest private constructor(builder: Builder) {
    /**
     * The status of computes in a managed container fleet, based on the success of the latest update deployment.
     * + `ACTIVE` -- The compute is deployed with the correct container definitions. It is ready to process game servers and host game sessions.
     * + `IMPAIRED` -- An update deployment to the compute failed, and the compute is deployed with incorrect container definitions.
     */
    public val computeStatus: aws.sdk.kotlin.services.gamelift.model.ListComputeInputStatus? = builder.computeStatus
    /**
     * For computes in a managed container fleet, the name of the deployed container group definition.
     */
    public val containerGroupDefinitionName: kotlin.String? = builder.containerGroupDefinitionName
    /**
     * A unique identifier for the fleet to retrieve compute resources for.
     */
    public val fleetId: kotlin.String? = builder.fleetId
    /**
     * The maximum number of results to return. Use this parameter with `NextToken` to get results as a set of sequential pages.
     */
    public val limit: kotlin.Int? = builder.limit
    /**
     * The name of a location to retrieve compute resources for. For an Amazon GameLift Servers Anywhere fleet, use a custom location. For a managed fleet, provide a Amazon Web Services Region or Local Zone code (for example: `us-west-2` or `us-west-2-lax-1`).
     */
    public val location: kotlin.String? = builder.location
    /**
     * A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.ListComputeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListComputeRequest(")
        append("computeStatus=$computeStatus,")
        append("containerGroupDefinitionName=$containerGroupDefinitionName,")
        append("fleetId=$fleetId,")
        append("limit=$limit,")
        append("location=$location,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = computeStatus?.hashCode() ?: 0
        result = 31 * result + (containerGroupDefinitionName?.hashCode() ?: 0)
        result = 31 * result + (fleetId?.hashCode() ?: 0)
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListComputeRequest

        if (computeStatus != other.computeStatus) return false
        if (containerGroupDefinitionName != other.containerGroupDefinitionName) return false
        if (fleetId != other.fleetId) return false
        if (limit != other.limit) return false
        if (location != other.location) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.ListComputeRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The status of computes in a managed container fleet, based on the success of the latest update deployment.
         * + `ACTIVE` -- The compute is deployed with the correct container definitions. It is ready to process game servers and host game sessions.
         * + `IMPAIRED` -- An update deployment to the compute failed, and the compute is deployed with incorrect container definitions.
         */
        public var computeStatus: aws.sdk.kotlin.services.gamelift.model.ListComputeInputStatus? = null
        /**
         * For computes in a managed container fleet, the name of the deployed container group definition.
         */
        public var containerGroupDefinitionName: kotlin.String? = null
        /**
         * A unique identifier for the fleet to retrieve compute resources for.
         */
        public var fleetId: kotlin.String? = null
        /**
         * The maximum number of results to return. Use this parameter with `NextToken` to get results as a set of sequential pages.
         */
        public var limit: kotlin.Int? = null
        /**
         * The name of a location to retrieve compute resources for. For an Amazon GameLift Servers Anywhere fleet, use a custom location. For a managed fleet, provide a Amazon Web Services Region or Local Zone code (for example: `us-west-2` or `us-west-2-lax-1`).
         */
        public var location: kotlin.String? = null
        /**
         * A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.ListComputeRequest) : this() {
            this.computeStatus = x.computeStatus
            this.containerGroupDefinitionName = x.containerGroupDefinitionName
            this.fleetId = x.fleetId
            this.limit = x.limit
            this.location = x.location
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.ListComputeRequest = ListComputeRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
