// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A range of IP addresses and port settings that allow inbound traffic to connect to processes on an instance in a fleet. Processes are assigned an IP address/port number combination, which must fall into the fleet's allowed ranges.
 *
 * For Amazon GameLift Servers Realtime fleets, Amazon GameLift Servers automatically opens two port ranges, one for TCP messaging and one for UDP.
 */
public class IpPermission private constructor(builder: Builder) {
    /**
     * A starting value for a range of allowed port numbers.
     *
     * For fleets using Linux builds, only ports `22` and `1026-60000` are valid.
     *
     * For fleets using Windows builds, only ports `1026-60000` are valid.
     */
    public val fromPort: kotlin.Int? = builder.fromPort
    /**
     * A range of allowed IP addresses. This value must be expressed in CIDR notation. Example: "`000.000.000.000/[subnet mask]`" or optionally the shortened version "`0.0.0.0/[subnet mask]`".
     */
    public val ipRange: kotlin.String? = builder.ipRange
    /**
     * The network communication protocol used by the fleet.
     */
    public val protocol: aws.sdk.kotlin.services.gamelift.model.IpProtocol? = builder.protocol
    /**
     * An ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be equal to or greater than `FromPort`.
     *
     * For fleets using Linux builds, only ports `22` and `1026-60000` are valid.
     *
     * For fleets using Windows builds, only ports `1026-60000` are valid.
     */
    public val toPort: kotlin.Int? = builder.toPort

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.IpPermission = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IpPermission(")
        append("fromPort=*** Sensitive Data Redacted ***,")
        append("ipRange=*** Sensitive Data Redacted ***,")
        append("protocol=$protocol,")
        append("toPort=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fromPort ?: 0
        result = 31 * result + (ipRange?.hashCode() ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (toPort ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IpPermission

        if (fromPort != other.fromPort) return false
        if (ipRange != other.ipRange) return false
        if (protocol != other.protocol) return false
        if (toPort != other.toPort) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.IpPermission = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A starting value for a range of allowed port numbers.
         *
         * For fleets using Linux builds, only ports `22` and `1026-60000` are valid.
         *
         * For fleets using Windows builds, only ports `1026-60000` are valid.
         */
        public var fromPort: kotlin.Int? = null
        /**
         * A range of allowed IP addresses. This value must be expressed in CIDR notation. Example: "`000.000.000.000/[subnet mask]`" or optionally the shortened version "`0.0.0.0/[subnet mask]`".
         */
        public var ipRange: kotlin.String? = null
        /**
         * The network communication protocol used by the fleet.
         */
        public var protocol: aws.sdk.kotlin.services.gamelift.model.IpProtocol? = null
        /**
         * An ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be equal to or greater than `FromPort`.
         *
         * For fleets using Linux builds, only ports `22` and `1026-60000` are valid.
         *
         * For fleets using Windows builds, only ports `1026-60000` are valid.
         */
        public var toPort: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.IpPermission) : this() {
            this.fromPort = x.fromPort
            this.ipRange = x.ipRange
            this.protocol = x.protocol
            this.toPort = x.toPort
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.IpPermission = IpPermission(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
