// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information and credentials that you can use to remotely connect to an instance in an EC2 managed fleet. This data type is returned in response to a call to [https://docs.aws.amazon.com/gamelift/latest/apireference/API_GetInstanceAccess](https://docs.aws.amazon.com/gamelift/latest/apireference/API_GetInstanceAccess).
 */
public class InstanceAccess private constructor(builder: Builder) {
    /**
     * Security credentials that are required to access the instance.
     */
    public val credentials: aws.sdk.kotlin.services.gamelift.model.InstanceCredentials? = builder.credentials
    /**
     * A unique identifier for the fleet containing the instance to be accessed.
     */
    public val fleetId: kotlin.String? = builder.fleetId
    /**
     * A unique identifier for the instance to be accessed.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * IP address assigned to the instance.
     */
    public val ipAddress: kotlin.String? = builder.ipAddress
    /**
     * Operating system that is running on the instance.
     */
    public val operatingSystem: aws.sdk.kotlin.services.gamelift.model.OperatingSystem? = builder.operatingSystem

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.InstanceAccess = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceAccess(")
        append("credentials=*** Sensitive Data Redacted ***,")
        append("fleetId=$fleetId,")
        append("instanceId=$instanceId,")
        append("ipAddress=*** Sensitive Data Redacted ***,")
        append("operatingSystem=$operatingSystem")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = credentials?.hashCode() ?: 0
        result = 31 * result + (fleetId?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (ipAddress?.hashCode() ?: 0)
        result = 31 * result + (operatingSystem?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceAccess

        if (credentials != other.credentials) return false
        if (fleetId != other.fleetId) return false
        if (instanceId != other.instanceId) return false
        if (ipAddress != other.ipAddress) return false
        if (operatingSystem != other.operatingSystem) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.InstanceAccess = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Security credentials that are required to access the instance.
         */
        public var credentials: aws.sdk.kotlin.services.gamelift.model.InstanceCredentials? = null
        /**
         * A unique identifier for the fleet containing the instance to be accessed.
         */
        public var fleetId: kotlin.String? = null
        /**
         * A unique identifier for the instance to be accessed.
         */
        public var instanceId: kotlin.String? = null
        /**
         * IP address assigned to the instance.
         */
        public var ipAddress: kotlin.String? = null
        /**
         * Operating system that is running on the instance.
         */
        public var operatingSystem: aws.sdk.kotlin.services.gamelift.model.OperatingSystem? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.InstanceAccess) : this() {
            this.credentials = x.credentials
            this.fleetId = x.fleetId
            this.instanceId = x.instanceId
            this.ipAddress = x.ipAddress
            this.operatingSystem = x.operatingSystem
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.InstanceAccess = InstanceAccess(this)

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.InstanceCredentials] inside the given [block]
         */
        public fun credentials(block: aws.sdk.kotlin.services.gamelift.model.InstanceCredentials.Builder.() -> kotlin.Unit) {
            this.credentials = aws.sdk.kotlin.services.gamelift.model.InstanceCredentials.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
