// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

public class GetComputeAccessResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is assigned to an Amazon GameLift Servers compute resource and uniquely identifies it. ARNs are unique across all Regions. Format is `arn:aws:gamelift:<region>::compute/compute-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912`.
     */
    public val computeArn: kotlin.String? = builder.computeArn
    /**
     * The identifier of the compute resource to be accessed. This value might be either a compute name or an instance ID.
     */
    public val computeName: kotlin.String? = builder.computeName
    /**
     * For a managed container fleet, a list of containers on the compute. Use the container runtime ID with Docker commands to connect to a specific container.
     */
    public val containerIdentifiers: List<ContainerIdentifier>? = builder.containerIdentifiers
    /**
     * A set of temporary Amazon Web Services credentials for use when connecting to the compute resource with Amazon EC2 Systems Manager (SSM).
     */
    public val credentials: aws.sdk.kotlin.services.gamelift.model.AwsCredentials? = builder.credentials
    /**
     * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is assigned to a Amazon GameLift Servers fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is `arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912`.
     */
    public val fleetArn: kotlin.String? = builder.fleetArn
    /**
     * The ID of the fleet that holds the compute resource to be accessed.
     */
    public val fleetId: kotlin.String? = builder.fleetId
    /**
     * The instance ID where the compute resource is running.
     */
    public val target: kotlin.String? = builder.target

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.GetComputeAccessResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetComputeAccessResponse(")
        append("computeArn=$computeArn,")
        append("computeName=$computeName,")
        append("containerIdentifiers=$containerIdentifiers,")
        append("credentials=*** Sensitive Data Redacted ***,")
        append("fleetArn=$fleetArn,")
        append("fleetId=$fleetId,")
        append("target=$target")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = computeArn?.hashCode() ?: 0
        result = 31 * result + (computeName?.hashCode() ?: 0)
        result = 31 * result + (containerIdentifiers?.hashCode() ?: 0)
        result = 31 * result + (credentials?.hashCode() ?: 0)
        result = 31 * result + (fleetArn?.hashCode() ?: 0)
        result = 31 * result + (fleetId?.hashCode() ?: 0)
        result = 31 * result + (target?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetComputeAccessResponse

        if (computeArn != other.computeArn) return false
        if (computeName != other.computeName) return false
        if (containerIdentifiers != other.containerIdentifiers) return false
        if (credentials != other.credentials) return false
        if (fleetArn != other.fleetArn) return false
        if (fleetId != other.fleetId) return false
        if (target != other.target) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.GetComputeAccessResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is assigned to an Amazon GameLift Servers compute resource and uniquely identifies it. ARNs are unique across all Regions. Format is `arn:aws:gamelift:<region>::compute/compute-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912`.
         */
        public var computeArn: kotlin.String? = null
        /**
         * The identifier of the compute resource to be accessed. This value might be either a compute name or an instance ID.
         */
        public var computeName: kotlin.String? = null
        /**
         * For a managed container fleet, a list of containers on the compute. Use the container runtime ID with Docker commands to connect to a specific container.
         */
        public var containerIdentifiers: List<ContainerIdentifier>? = null
        /**
         * A set of temporary Amazon Web Services credentials for use when connecting to the compute resource with Amazon EC2 Systems Manager (SSM).
         */
        public var credentials: aws.sdk.kotlin.services.gamelift.model.AwsCredentials? = null
        /**
         * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is assigned to a Amazon GameLift Servers fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is `arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912`.
         */
        public var fleetArn: kotlin.String? = null
        /**
         * The ID of the fleet that holds the compute resource to be accessed.
         */
        public var fleetId: kotlin.String? = null
        /**
         * The instance ID where the compute resource is running.
         */
        public var target: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.GetComputeAccessResponse) : this() {
            this.computeArn = x.computeArn
            this.computeName = x.computeName
            this.containerIdentifiers = x.containerIdentifiers
            this.credentials = x.credentials
            this.fleetArn = x.fleetArn
            this.fleetId = x.fleetId
            this.target = x.target
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.GetComputeAccessResponse = GetComputeAccessResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.AwsCredentials] inside the given [block]
         */
        public fun credentials(block: aws.sdk.kotlin.services.gamelift.model.AwsCredentials.Builder.() -> kotlin.Unit) {
            this.credentials = aws.sdk.kotlin.services.gamelift.model.AwsCredentials.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
