// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents a potential game session placement, including the full details of the original placement request and the current status.
 *
 * If the game session placement status is `PENDING`, the properties for game session ID/ARN, region, IP address/DNS, and port aren't final. A game session is not active and ready to accept players until placement status reaches `FULFILLED`. When the placement is in `PENDING` status, Amazon GameLift Servers may attempt to place a game session multiple times before succeeding. With each attempt it creates a [https://docs.aws.amazon.com/gamelift/latest/apireference/API_GameSession](https://docs.aws.amazon.com/gamelift/latest/apireference/API_GameSession) object and updates this placement object with the new game session properties.
 */
public class GameSessionPlacement private constructor(builder: Builder) {
    /**
     * The DNS identifier assigned to the instance that is running the game session. Values have the following format:
     * + TLS-enabled fleets: `<unique identifier>.<region identifier>.amazongamelift.com`.
     * + Non-TLS-enabled fleets: `ec2-<unique identifier>.compute.amazonaws.com`. (See [Amazon EC2 Instance IP Addressing](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses).)
     *
     * When connecting to a game session that is running on a TLS-enabled fleet, you must use the DNS name, not the IP address.
     */
    public val dnsName: kotlin.String? = builder.dnsName
    /**
     * Time stamp indicating when this request was completed, canceled, or timed out.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * A set of key-value pairs that can store custom data in a game session. For example: `{"Key": "difficulty", "Value": "novice"}`.
     */
    public val gameProperties: List<GameProperty>? = builder.gameProperties
    /**
     * Identifier for the game session created by this placement request. This identifier is unique across all Regions. This value isn't final until placement status is `FULFILLED`.
     */
    public val gameSessionArn: kotlin.String? = builder.gameSessionArn
    /**
     * A set of custom game session properties, formatted as a single string value. This data is passed to a game server process with a request to start a new game session. For more information, see [Start a game session](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession).
     */
    public val gameSessionData: kotlin.String? = builder.gameSessionData
    /**
     * A unique identifier for the game session. This value isn't final until placement status is `FULFILLED`.
     */
    public val gameSessionId: kotlin.String? = builder.gameSessionId
    /**
     * A descriptive label that is associated with a game session. Session names do not need to be unique.
     */
    public val gameSessionName: kotlin.String? = builder.gameSessionName
    /**
     * A descriptive label that is associated with game session queue. Queue names must be unique within each Region.
     */
    public val gameSessionQueueName: kotlin.String? = builder.gameSessionQueueName
    /**
     * Name of the Region where the game session created by this placement request is running. This value isn't final until placement status is `FULFILLED`.
     */
    public val gameSessionRegion: kotlin.String? = builder.gameSessionRegion
    /**
     * The IP address of the game session. To connect to a Amazon GameLift Servers game server, an app needs both the IP address and port number. This value isn't final until placement status is `FULFILLED`.
     */
    public val ipAddress: kotlin.String? = builder.ipAddress
    /**
     * Information on the matchmaking process for this game. Data is in JSON syntax, formatted as a string. It identifies the matchmaking configuration used to create the match, and contains data on all players assigned to the match, including player attributes and team assignments. For more details on matchmaker data, see [Match Data](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-server.html#match-server-data).
     */
    public val matchmakerData: kotlin.String? = builder.matchmakerData
    /**
     * The maximum number of players that can be connected simultaneously to the game session.
     */
    public val maximumPlayerSessionCount: kotlin.Int? = builder.maximumPlayerSessionCount
    /**
     * A collection of information on player sessions created in response to the game session placement request. These player sessions are created only after a new game session is successfully placed (placement status is `FULFILLED`). This information includes the player ID, provided in the placement request, and a corresponding player session ID.
     */
    public val placedPlayerSessions: List<PlacedPlayerSession>? = builder.placedPlayerSessions
    /**
     * A unique identifier for a game session placement.
     */
    public val placementId: kotlin.String? = builder.placementId
    /**
     * A set of values, expressed in milliseconds, that indicates the amount of latency that a player experiences when connected to Amazon Web Services Regions.
     */
    public val playerLatencies: List<PlayerLatency>? = builder.playerLatencies
    /**
     * The port number for the game session. To connect to a Amazon GameLift Servers game server, an app needs both the IP address and port number. This value isn't final until placement status is `FULFILLED`.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * An alternative priority list of locations that's included with a game session placement request. When provided, the list overrides a queue's location order list for this game session placement request only. The list might include Amazon Web Services Regions, local zones, and custom locations (for Anywhere fleets). The fallback strategy tells Amazon GameLift Servers what action to take (if any) in the event that it failed to place a new game session.
     */
    public val priorityConfigurationOverride: aws.sdk.kotlin.services.gamelift.model.PriorityConfigurationOverride? = builder.priorityConfigurationOverride
    /**
     * Time stamp indicating when this request was placed in the queue. Format is a number expressed in Unix time as milliseconds (for example `"1469498468.057"`).
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * Current status of the game session placement request.
     * + **PENDING** -- The placement request is in the queue waiting to be processed. Game session properties are not yet final.
     * + **FULFILLED** -- A new game session has been successfully placed. Game session properties are now final.
     * + **CANCELLED** -- The placement request was canceled.
     * + **TIMED_OUT** -- A new game session was not successfully created before the time limit expired. You can resubmit the placement request as needed.
     * + **FAILED** -- Amazon GameLift Servers is not able to complete the process of placing the game session. Common reasons are the game session terminated before the placement process was completed, or an unexpected internal error.
     */
    public val status: aws.sdk.kotlin.services.gamelift.model.GameSessionPlacementState? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.GameSessionPlacement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GameSessionPlacement(")
        append("dnsName=$dnsName,")
        append("endTime=$endTime,")
        append("gameProperties=$gameProperties,")
        append("gameSessionArn=$gameSessionArn,")
        append("gameSessionData=$gameSessionData,")
        append("gameSessionId=$gameSessionId,")
        append("gameSessionName=$gameSessionName,")
        append("gameSessionQueueName=$gameSessionQueueName,")
        append("gameSessionRegion=$gameSessionRegion,")
        append("ipAddress=*** Sensitive Data Redacted ***,")
        append("matchmakerData=$matchmakerData,")
        append("maximumPlayerSessionCount=$maximumPlayerSessionCount,")
        append("placedPlayerSessions=$placedPlayerSessions,")
        append("placementId=$placementId,")
        append("playerLatencies=$playerLatencies,")
        append("port=*** Sensitive Data Redacted ***,")
        append("priorityConfigurationOverride=$priorityConfigurationOverride,")
        append("startTime=$startTime,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dnsName?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (gameProperties?.hashCode() ?: 0)
        result = 31 * result + (gameSessionArn?.hashCode() ?: 0)
        result = 31 * result + (gameSessionData?.hashCode() ?: 0)
        result = 31 * result + (gameSessionId?.hashCode() ?: 0)
        result = 31 * result + (gameSessionName?.hashCode() ?: 0)
        result = 31 * result + (gameSessionQueueName?.hashCode() ?: 0)
        result = 31 * result + (gameSessionRegion?.hashCode() ?: 0)
        result = 31 * result + (ipAddress?.hashCode() ?: 0)
        result = 31 * result + (matchmakerData?.hashCode() ?: 0)
        result = 31 * result + (maximumPlayerSessionCount ?: 0)
        result = 31 * result + (placedPlayerSessions?.hashCode() ?: 0)
        result = 31 * result + (placementId?.hashCode() ?: 0)
        result = 31 * result + (playerLatencies?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (priorityConfigurationOverride?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GameSessionPlacement

        if (dnsName != other.dnsName) return false
        if (endTime != other.endTime) return false
        if (gameProperties != other.gameProperties) return false
        if (gameSessionArn != other.gameSessionArn) return false
        if (gameSessionData != other.gameSessionData) return false
        if (gameSessionId != other.gameSessionId) return false
        if (gameSessionName != other.gameSessionName) return false
        if (gameSessionQueueName != other.gameSessionQueueName) return false
        if (gameSessionRegion != other.gameSessionRegion) return false
        if (ipAddress != other.ipAddress) return false
        if (matchmakerData != other.matchmakerData) return false
        if (maximumPlayerSessionCount != other.maximumPlayerSessionCount) return false
        if (placedPlayerSessions != other.placedPlayerSessions) return false
        if (placementId != other.placementId) return false
        if (playerLatencies != other.playerLatencies) return false
        if (port != other.port) return false
        if (priorityConfigurationOverride != other.priorityConfigurationOverride) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.GameSessionPlacement = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The DNS identifier assigned to the instance that is running the game session. Values have the following format:
         * + TLS-enabled fleets: `<unique identifier>.<region identifier>.amazongamelift.com`.
         * + Non-TLS-enabled fleets: `ec2-<unique identifier>.compute.amazonaws.com`. (See [Amazon EC2 Instance IP Addressing](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses).)
         *
         * When connecting to a game session that is running on a TLS-enabled fleet, you must use the DNS name, not the IP address.
         */
        public var dnsName: kotlin.String? = null
        /**
         * Time stamp indicating when this request was completed, canceled, or timed out.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A set of key-value pairs that can store custom data in a game session. For example: `{"Key": "difficulty", "Value": "novice"}`.
         */
        public var gameProperties: List<GameProperty>? = null
        /**
         * Identifier for the game session created by this placement request. This identifier is unique across all Regions. This value isn't final until placement status is `FULFILLED`.
         */
        public var gameSessionArn: kotlin.String? = null
        /**
         * A set of custom game session properties, formatted as a single string value. This data is passed to a game server process with a request to start a new game session. For more information, see [Start a game session](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession).
         */
        public var gameSessionData: kotlin.String? = null
        /**
         * A unique identifier for the game session. This value isn't final until placement status is `FULFILLED`.
         */
        public var gameSessionId: kotlin.String? = null
        /**
         * A descriptive label that is associated with a game session. Session names do not need to be unique.
         */
        public var gameSessionName: kotlin.String? = null
        /**
         * A descriptive label that is associated with game session queue. Queue names must be unique within each Region.
         */
        public var gameSessionQueueName: kotlin.String? = null
        /**
         * Name of the Region where the game session created by this placement request is running. This value isn't final until placement status is `FULFILLED`.
         */
        public var gameSessionRegion: kotlin.String? = null
        /**
         * The IP address of the game session. To connect to a Amazon GameLift Servers game server, an app needs both the IP address and port number. This value isn't final until placement status is `FULFILLED`.
         */
        public var ipAddress: kotlin.String? = null
        /**
         * Information on the matchmaking process for this game. Data is in JSON syntax, formatted as a string. It identifies the matchmaking configuration used to create the match, and contains data on all players assigned to the match, including player attributes and team assignments. For more details on matchmaker data, see [Match Data](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-server.html#match-server-data).
         */
        public var matchmakerData: kotlin.String? = null
        /**
         * The maximum number of players that can be connected simultaneously to the game session.
         */
        public var maximumPlayerSessionCount: kotlin.Int? = null
        /**
         * A collection of information on player sessions created in response to the game session placement request. These player sessions are created only after a new game session is successfully placed (placement status is `FULFILLED`). This information includes the player ID, provided in the placement request, and a corresponding player session ID.
         */
        public var placedPlayerSessions: List<PlacedPlayerSession>? = null
        /**
         * A unique identifier for a game session placement.
         */
        public var placementId: kotlin.String? = null
        /**
         * A set of values, expressed in milliseconds, that indicates the amount of latency that a player experiences when connected to Amazon Web Services Regions.
         */
        public var playerLatencies: List<PlayerLatency>? = null
        /**
         * The port number for the game session. To connect to a Amazon GameLift Servers game server, an app needs both the IP address and port number. This value isn't final until placement status is `FULFILLED`.
         */
        public var port: kotlin.Int? = null
        /**
         * An alternative priority list of locations that's included with a game session placement request. When provided, the list overrides a queue's location order list for this game session placement request only. The list might include Amazon Web Services Regions, local zones, and custom locations (for Anywhere fleets). The fallback strategy tells Amazon GameLift Servers what action to take (if any) in the event that it failed to place a new game session.
         */
        public var priorityConfigurationOverride: aws.sdk.kotlin.services.gamelift.model.PriorityConfigurationOverride? = null
        /**
         * Time stamp indicating when this request was placed in the queue. Format is a number expressed in Unix time as milliseconds (for example `"1469498468.057"`).
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Current status of the game session placement request.
         * + **PENDING** -- The placement request is in the queue waiting to be processed. Game session properties are not yet final.
         * + **FULFILLED** -- A new game session has been successfully placed. Game session properties are now final.
         * + **CANCELLED** -- The placement request was canceled.
         * + **TIMED_OUT** -- A new game session was not successfully created before the time limit expired. You can resubmit the placement request as needed.
         * + **FAILED** -- Amazon GameLift Servers is not able to complete the process of placing the game session. Common reasons are the game session terminated before the placement process was completed, or an unexpected internal error.
         */
        public var status: aws.sdk.kotlin.services.gamelift.model.GameSessionPlacementState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.GameSessionPlacement) : this() {
            this.dnsName = x.dnsName
            this.endTime = x.endTime
            this.gameProperties = x.gameProperties
            this.gameSessionArn = x.gameSessionArn
            this.gameSessionData = x.gameSessionData
            this.gameSessionId = x.gameSessionId
            this.gameSessionName = x.gameSessionName
            this.gameSessionQueueName = x.gameSessionQueueName
            this.gameSessionRegion = x.gameSessionRegion
            this.ipAddress = x.ipAddress
            this.matchmakerData = x.matchmakerData
            this.maximumPlayerSessionCount = x.maximumPlayerSessionCount
            this.placedPlayerSessions = x.placedPlayerSessions
            this.placementId = x.placementId
            this.playerLatencies = x.playerLatencies
            this.port = x.port
            this.priorityConfigurationOverride = x.priorityConfigurationOverride
            this.startTime = x.startTime
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.GameSessionPlacement = GameSessionPlacement(this)

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.PriorityConfigurationOverride] inside the given [block]
         */
        public fun priorityConfigurationOverride(block: aws.sdk.kotlin.services.gamelift.model.PriorityConfigurationOverride.Builder.() -> kotlin.Unit) {
            this.priorityConfigurationOverride = aws.sdk.kotlin.services.gamelift.model.PriorityConfigurationOverride.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
