// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A policy that puts limits on the number of game sessions that a player can create within a specified span of time. With this policy, you can control players' ability to consume available resources.
 *
 * The policy is evaluated when a player tries to create a new game session. On receiving a `CreateGameSession` request, Amazon GameLift Servers checks that the player (identified by `CreatorId`) has created fewer than game session limit in the specified time period.
 */
public class GameSessionCreationLimitPolicy private constructor(builder: Builder) {
    /**
     * A policy that puts limits on the number of game sessions that a player can create within a specified span of time. With this policy, you can control players' ability to consume available resources.
     *
     * The policy evaluates when a player tries to create a new game session. On receiving a `CreateGameSession` request, Amazon GameLift Servers checks that the player (identified by `CreatorId`) has created fewer than game session limit in the specified time period.
     */
    public val newGameSessionsPerCreator: kotlin.Int? = builder.newGameSessionsPerCreator
    /**
     * The time span used in evaluating the resource creation limit policy.
     */
    public val policyPeriodInMinutes: kotlin.Int? = builder.policyPeriodInMinutes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.GameSessionCreationLimitPolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GameSessionCreationLimitPolicy(")
        append("newGameSessionsPerCreator=$newGameSessionsPerCreator,")
        append("policyPeriodInMinutes=$policyPeriodInMinutes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = newGameSessionsPerCreator ?: 0
        result = 31 * result + (policyPeriodInMinutes ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GameSessionCreationLimitPolicy

        if (newGameSessionsPerCreator != other.newGameSessionsPerCreator) return false
        if (policyPeriodInMinutes != other.policyPeriodInMinutes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.GameSessionCreationLimitPolicy = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A policy that puts limits on the number of game sessions that a player can create within a specified span of time. With this policy, you can control players' ability to consume available resources.
         *
         * The policy evaluates when a player tries to create a new game session. On receiving a `CreateGameSession` request, Amazon GameLift Servers checks that the player (identified by `CreatorId`) has created fewer than game session limit in the specified time period.
         */
        public var newGameSessionsPerCreator: kotlin.Int? = null
        /**
         * The time span used in evaluating the resource creation limit policy.
         */
        public var policyPeriodInMinutes: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.GameSessionCreationLimitPolicy) : this() {
            this.newGameSessionsPerCreator = x.newGameSessionsPerCreator
            this.policyPeriodInMinutes = x.policyPeriodInMinutes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.GameSessionCreationLimitPolicy = GameSessionCreationLimitPolicy(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
