// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * **This data type is used with the Amazon GameLift Servers FleetIQ and game server groups.**
 *
 *  Additional properties, including status, that describe an EC2 instance in a game server group. Instance configurations are set with game server group properties (see `DescribeGameServerGroup` and with the EC2 launch template that was used when creating the game server group.
 *
 * Retrieve game server instances for a game server group by calling `DescribeGameServerInstances`.
 */
public class GameServerInstance private constructor(builder: Builder) {
    /**
     * A generated unique identifier for the game server group that includes the game server instance.
     */
    public val gameServerGroupArn: kotlin.String? = builder.gameServerGroupArn
    /**
     * A developer-defined identifier for the game server group that includes the game server instance. The name is unique for each Region in each Amazon Web Services account.
     */
    public val gameServerGroupName: kotlin.String? = builder.gameServerGroupName
    /**
     * The unique identifier for the instance where the game server is running. This ID is available in the instance metadata. EC2 instance IDs use a 17-character format, for example: `i-1234567890abcdef0`.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * Current status of the game server instance
     */
    public val instanceStatus: aws.sdk.kotlin.services.gamelift.model.GameServerInstanceStatus? = builder.instanceStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.GameServerInstance = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GameServerInstance(")
        append("gameServerGroupArn=$gameServerGroupArn,")
        append("gameServerGroupName=$gameServerGroupName,")
        append("instanceId=$instanceId,")
        append("instanceStatus=$instanceStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = gameServerGroupArn?.hashCode() ?: 0
        result = 31 * result + (gameServerGroupName?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (instanceStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GameServerInstance

        if (gameServerGroupArn != other.gameServerGroupArn) return false
        if (gameServerGroupName != other.gameServerGroupName) return false
        if (instanceId != other.instanceId) return false
        if (instanceStatus != other.instanceStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.GameServerInstance = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A generated unique identifier for the game server group that includes the game server instance.
         */
        public var gameServerGroupArn: kotlin.String? = null
        /**
         * A developer-defined identifier for the game server group that includes the game server instance. The name is unique for each Region in each Amazon Web Services account.
         */
        public var gameServerGroupName: kotlin.String? = null
        /**
         * The unique identifier for the instance where the game server is running. This ID is available in the instance metadata. EC2 instance IDs use a 17-character format, for example: `i-1234567890abcdef0`.
         */
        public var instanceId: kotlin.String? = null
        /**
         * Current status of the game server instance
         */
        public var instanceStatus: aws.sdk.kotlin.services.gamelift.model.GameServerInstanceStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.GameServerInstance) : this() {
            this.gameServerGroupArn = x.gameServerGroupArn
            this.gameServerGroupName = x.gameServerGroupName
            this.instanceId = x.instanceId
            this.instanceStatus = x.instanceStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.GameServerInstance = GameServerInstance(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
