// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The number and status of game server container groups that are deployed across a container fleet. Combine this count with the number of server processes that each game server container group runs to learn how many game sessions the fleet is capable of hosting concurrently. For example, if a fleet has 50 game server container groups, and the game server container in each group runs 1 game server process, then the fleet has the capacity to run host 50 game sessions at a time.
 *
 * **Returned by:**[https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetCapacity.html](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetCapacity.html), [https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationCapacity.html](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationCapacity.html)
 */
public class GameServerContainerGroupCounts private constructor(builder: Builder) {
    /**
     * The number of container groups that have active game sessions.
     */
    public val active: kotlin.Int? = builder.active
    /**
     * The number of container groups that have no active game sessions.
     */
    public val idle: kotlin.Int? = builder.idle
    /**
     * The number of container groups that are starting up but haven't yet registered.
     */
    public val pending: kotlin.Int? = builder.pending
    /**
     * The number of container groups that are in the process of shutting down.
     */
    public val terminating: kotlin.Int? = builder.terminating

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.GameServerContainerGroupCounts = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GameServerContainerGroupCounts(")
        append("active=$active,")
        append("idle=$idle,")
        append("pending=$pending,")
        append("terminating=$terminating")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = active ?: 0
        result = 31 * result + (idle ?: 0)
        result = 31 * result + (pending ?: 0)
        result = 31 * result + (terminating ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GameServerContainerGroupCounts

        if (active != other.active) return false
        if (idle != other.idle) return false
        if (pending != other.pending) return false
        if (terminating != other.terminating) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.GameServerContainerGroupCounts = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of container groups that have active game sessions.
         */
        public var active: kotlin.Int? = null
        /**
         * The number of container groups that have no active game sessions.
         */
        public var idle: kotlin.Int? = null
        /**
         * The number of container groups that are starting up but haven't yet registered.
         */
        public var pending: kotlin.Int? = null
        /**
         * The number of container groups that are in the process of shutting down.
         */
        public var terminating: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.GameServerContainerGroupCounts) : this() {
            this.active = x.active
            this.idle = x.idle
            this.pending = x.pending
            this.terminating = x.terminating
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.GameServerContainerGroupCounts = GameServerContainerGroupCounts(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
