// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a container fleet deployment with updates to the fleet.
 */
public class FleetDeployment private constructor(builder: Builder) {
    /**
     * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example `"1469498468.057"`).
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * Instructions for how to deploy updates to a container fleet and what actions to take if the deployment fails.
     */
    public val deploymentConfiguration: aws.sdk.kotlin.services.gamelift.model.DeploymentConfiguration? = builder.deploymentConfiguration
    /**
     * A unique identifier for the deployment.
     */
    public val deploymentId: kotlin.String? = builder.deploymentId
    /**
     * The status of fleet deployment activity in the location.
     * + `IN_PROGRESS` -- The deployment is in progress.
     * + `IMPAIRED` -- The deployment failed and the fleet has some impaired containers.
     * + `COMPLETE` -- The deployment has completed successfully.
     * + `ROLLBACK_IN_PROGRESS` -- The deployment failed and rollback has been initiated.
     * + `ROLLBACK_IN_COMPLETE` -- The deployment failed and rollback has been completed.
     * + `CANCELLED` -- The deployment was cancelled.
     */
    public val deploymentStatus: aws.sdk.kotlin.services.gamelift.model.DeploymentStatus? = builder.deploymentStatus
    /**
     * A unique identifier for the container fleet.
     */
    public val fleetId: kotlin.String? = builder.fleetId
    /**
     * The unique identifier for the version of the game server container group definition that is being deployed.
     */
    public val gameServerBinaryArn: kotlin.String? = builder.gameServerBinaryArn
    /**
     * The unique identifier for the version of the per-instance container group definition that is being deployed.
     */
    public val perInstanceBinaryArn: kotlin.String? = builder.perInstanceBinaryArn
    /**
     * The unique identifier for the version of the game server container group definition to roll back to if deployment fails. Amazon GameLift Servers sets this property to the container group definition version that the fleet used when it was last active.
     */
    public val rollbackGameServerBinaryArn: kotlin.String? = builder.rollbackGameServerBinaryArn
    /**
     * The unique identifier for the version of the per-instance container group definition to roll back to if deployment fails. Amazon GameLift Servers sets this property to the container group definition version that the fleet used when it was last active.
     */
    public val rollbackPerInstanceBinaryArn: kotlin.String? = builder.rollbackPerInstanceBinaryArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.FleetDeployment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FleetDeployment(")
        append("creationTime=$creationTime,")
        append("deploymentConfiguration=$deploymentConfiguration,")
        append("deploymentId=$deploymentId,")
        append("deploymentStatus=$deploymentStatus,")
        append("fleetId=$fleetId,")
        append("gameServerBinaryArn=$gameServerBinaryArn,")
        append("perInstanceBinaryArn=$perInstanceBinaryArn,")
        append("rollbackGameServerBinaryArn=$rollbackGameServerBinaryArn,")
        append("rollbackPerInstanceBinaryArn=$rollbackPerInstanceBinaryArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (deploymentConfiguration?.hashCode() ?: 0)
        result = 31 * result + (deploymentId?.hashCode() ?: 0)
        result = 31 * result + (deploymentStatus?.hashCode() ?: 0)
        result = 31 * result + (fleetId?.hashCode() ?: 0)
        result = 31 * result + (gameServerBinaryArn?.hashCode() ?: 0)
        result = 31 * result + (perInstanceBinaryArn?.hashCode() ?: 0)
        result = 31 * result + (rollbackGameServerBinaryArn?.hashCode() ?: 0)
        result = 31 * result + (rollbackPerInstanceBinaryArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FleetDeployment

        if (creationTime != other.creationTime) return false
        if (deploymentConfiguration != other.deploymentConfiguration) return false
        if (deploymentId != other.deploymentId) return false
        if (deploymentStatus != other.deploymentStatus) return false
        if (fleetId != other.fleetId) return false
        if (gameServerBinaryArn != other.gameServerBinaryArn) return false
        if (perInstanceBinaryArn != other.perInstanceBinaryArn) return false
        if (rollbackGameServerBinaryArn != other.rollbackGameServerBinaryArn) return false
        if (rollbackPerInstanceBinaryArn != other.rollbackPerInstanceBinaryArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.FleetDeployment = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example `"1469498468.057"`).
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Instructions for how to deploy updates to a container fleet and what actions to take if the deployment fails.
         */
        public var deploymentConfiguration: aws.sdk.kotlin.services.gamelift.model.DeploymentConfiguration? = null
        /**
         * A unique identifier for the deployment.
         */
        public var deploymentId: kotlin.String? = null
        /**
         * The status of fleet deployment activity in the location.
         * + `IN_PROGRESS` -- The deployment is in progress.
         * + `IMPAIRED` -- The deployment failed and the fleet has some impaired containers.
         * + `COMPLETE` -- The deployment has completed successfully.
         * + `ROLLBACK_IN_PROGRESS` -- The deployment failed and rollback has been initiated.
         * + `ROLLBACK_IN_COMPLETE` -- The deployment failed and rollback has been completed.
         * + `CANCELLED` -- The deployment was cancelled.
         */
        public var deploymentStatus: aws.sdk.kotlin.services.gamelift.model.DeploymentStatus? = null
        /**
         * A unique identifier for the container fleet.
         */
        public var fleetId: kotlin.String? = null
        /**
         * The unique identifier for the version of the game server container group definition that is being deployed.
         */
        public var gameServerBinaryArn: kotlin.String? = null
        /**
         * The unique identifier for the version of the per-instance container group definition that is being deployed.
         */
        public var perInstanceBinaryArn: kotlin.String? = null
        /**
         * The unique identifier for the version of the game server container group definition to roll back to if deployment fails. Amazon GameLift Servers sets this property to the container group definition version that the fleet used when it was last active.
         */
        public var rollbackGameServerBinaryArn: kotlin.String? = null
        /**
         * The unique identifier for the version of the per-instance container group definition to roll back to if deployment fails. Amazon GameLift Servers sets this property to the container group definition version that the fleet used when it was last active.
         */
        public var rollbackPerInstanceBinaryArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.FleetDeployment) : this() {
            this.creationTime = x.creationTime
            this.deploymentConfiguration = x.deploymentConfiguration
            this.deploymentId = x.deploymentId
            this.deploymentStatus = x.deploymentStatus
            this.fleetId = x.fleetId
            this.gameServerBinaryArn = x.gameServerBinaryArn
            this.perInstanceBinaryArn = x.perInstanceBinaryArn
            this.rollbackGameServerBinaryArn = x.rollbackGameServerBinaryArn
            this.rollbackPerInstanceBinaryArn = x.rollbackPerInstanceBinaryArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.FleetDeployment = FleetDeployment(this)

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.DeploymentConfiguration] inside the given [block]
         */
        public fun deploymentConfiguration(block: aws.sdk.kotlin.services.gamelift.model.DeploymentConfiguration.Builder.() -> kotlin.Unit) {
            this.deploymentConfiguration = aws.sdk.kotlin.services.gamelift.model.DeploymentConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
