// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an Amazon GameLift Servers fleet of game hosting resources. Attributes differ based on the fleet's compute type, as follows:
 * + EC2 fleet attributes identify a `Build` resource (for fleets with customer game server builds) or a `Script` resource (for Amazon GameLift Servers Realtime fleets).
 * + Amazon GameLift Servers Anywhere fleets have an abbreviated set of attributes, because most fleet configurations are set directly on the fleet's computes. Attributes include fleet identifiers and descriptive properties, creation/termination time, and fleet status.
 *
 * **Returned by:**[https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetAttributes](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetAttributes)
 */
public class FleetAttributes private constructor(builder: Builder) {
    /**
     * A set of attributes that are specific to an Anywhere fleet.
     */
    public val anywhereConfiguration: aws.sdk.kotlin.services.gamelift.model.AnywhereConfiguration? = builder.anywhereConfiguration
    /**
     * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) associated with the Amazon GameLift Servers build resource that is deployed on instances in this fleet. In a GameLift build ARN, the resource ID matches the `BuildId` value. This attribute is used with fleets where `ComputeType` is "EC2".
     */
    public val buildArn: kotlin.String? = builder.buildArn
    /**
     * A unique identifier for the build resource that is deployed on instances in this fleet. This attribute is used with fleets where `ComputeType` is "EC2".
     */
    public val buildId: kotlin.String? = builder.buildId
    /**
     * Determines whether a TLS/SSL certificate is generated for a fleet. This feature must be enabled when creating the fleet. All instances in a fleet share the same certificate.
     */
    public val certificateConfiguration: aws.sdk.kotlin.services.gamelift.model.CertificateConfiguration? = builder.certificateConfiguration
    /**
     * The type of compute resource used to host your game servers. You can use your own compute resources with Amazon GameLift Servers Anywhere or use Amazon EC2 instances with managed Amazon GameLift Servers.
     */
    public val computeType: aws.sdk.kotlin.services.gamelift.model.ComputeType? = builder.computeType
    /**
     * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example `"1469498468.057"`).
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * A human-readable description of the fleet.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is assigned to a Amazon GameLift Servers fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is `arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912`. In a GameLift fleet ARN, the resource ID matches the `FleetId` value.
     */
    public val fleetArn: kotlin.String? = builder.fleetArn
    /**
     * A unique identifier for the fleet.
     */
    public val fleetId: kotlin.String? = builder.fleetId
    /**
     * Indicates whether the fleet uses On-Demand or Spot instances. For more information, see [ On-Demand versus Spot Instances](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot). This fleet property can't be changed after the fleet is created.
     */
    public val fleetType: aws.sdk.kotlin.services.gamelift.model.FleetType? = builder.fleetType
    /**
     * A unique identifier for an IAM role that manages access to your Amazon Web Services services. With an instance role ARN set, any application that runs on an instance in this fleet can assume the role, including install scripts, server processes, and daemons (background processes). Create a role or look up a role's ARN by using the [IAM dashboard](https://console.aws.amazon.com/iam/) in the Amazon Web Services Management Console. Learn more about using on-box credentials for your game servers at [ Access external resources from a game server](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html). This attribute is used with fleets where `ComputeType` is `EC2`.
     */
    public val instanceRoleArn: kotlin.String? = builder.instanceRoleArn
    /**
     * Indicates that fleet instances maintain a shared credentials file for the IAM role defined in `InstanceRoleArn`. Shared credentials allow applications that are deployed with the game server executable to communicate with other Amazon Web Services resources. This property is used only when the game server is integrated with the server SDK version 5.x. For more information about using shared credentials, see [ Communicate with other Amazon Web Services resources from your fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html). This attribute is used with fleets where `ComputeType` is `EC2`.
     */
    public val instanceRoleCredentialsProvider: aws.sdk.kotlin.services.gamelift.model.InstanceRoleCredentialsProvider? = builder.instanceRoleCredentialsProvider
    /**
     * The Amazon EC2 instance type that the fleet uses. Instance type determines the computing resources of each instance in the fleet, including CPU, memory, storage, and networking capacity. See [Amazon Elastic Compute Cloud Instance Types](http://aws.amazon.com/ec2/instance-types/) for detailed descriptions. This attribute is used with fleets where `ComputeType` is `EC2`.
     */
    public val instanceType: aws.sdk.kotlin.services.gamelift.model.Ec2InstanceType? = builder.instanceType
    /**
     * **This parameter is no longer used.** Game session log paths are now defined using the Amazon GameLift Servers server API `ProcessReady()``logParameters`. See more information in the [Server API Reference](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process).
     */
    public val logPaths: List<String>? = builder.logPaths
    /**
     * Name of a metric group that metrics for this fleet are added to. In Amazon CloudWatch, you can view aggregated metrics for fleets that are in a metric group. A fleet can be included in only one metric group at a time. This attribute is used with fleets where `ComputeType` is `EC2`.
     */
    public val metricGroups: List<String>? = builder.metricGroups
    /**
     * A descriptive label that is associated with a fleet. Fleet names do not need to be unique.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The type of game session protection to set on all new instances that are started in the fleet. This attribute is used with fleets where `ComputeType` is `EC2`.
     * + **NoProtection** -- The game session can be terminated during a scale-down event.
     * + **FullProtection** -- If the game session is in an `ACTIVE` status, it cannot be terminated during a scale-down event.
     */
    public val newGameSessionProtectionPolicy: aws.sdk.kotlin.services.gamelift.model.ProtectionPolicy? = builder.newGameSessionProtectionPolicy
    /**
     * The operating system of the fleet's computing resources. A fleet's operating system is determined by the OS of the build or script that is deployed on this fleet. This attribute is used with fleets where `ComputeType` is `EC2`.
     *
     * Amazon Linux 2 (AL2) will reach end of support on 6/30/2025. See more details in the [Amazon Linux 2 FAQs](http://aws.amazon.com/aws.amazon.com/amazon-linux-2/faqs/). For game servers that are hosted on AL2 and use server SDK version 4.x for Amazon GameLift Servers, first update the game server build to server SDK 5.x, and then deploy to AL2023 instances. See [ Migrate to server SDK version 5.](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk5-migration.html)
     */
    public val operatingSystem: aws.sdk.kotlin.services.gamelift.model.OperatingSystem? = builder.operatingSystem
    /**
     * A policy that puts limits on the number of game sessions that a player can create within a specified span of time. With this policy, you can control players' ability to consume available resources.
     *
     * The policy is evaluated when a player tries to create a new game session. On receiving a `CreateGameSession` request, Amazon GameLift Servers checks that the player (identified by `CreatorId`) has created fewer than game session limit in the specified time period.
     */
    public val resourceCreationLimitPolicy: aws.sdk.kotlin.services.gamelift.model.ResourceCreationLimitPolicy? = builder.resourceCreationLimitPolicy
    /**
     * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) associated with the GameLift script resource that is deployed on instances in this fleet. In a GameLift script ARN, the resource ID matches the `ScriptId` value.
     */
    public val scriptArn: kotlin.String? = builder.scriptArn
    /**
     * A unique identifier for the Realtime script resource that is deployed on instances in this fleet. This attribute is used with fleets where `ComputeType` is "EC2".
     */
    public val scriptId: kotlin.String? = builder.scriptId
    /**
     * **This parameter is no longer used.** Server launch parameters are now defined using the fleet's runtime configuration. Requests that use this parameter continue to be valid.
     */
    public val serverLaunchParameters: kotlin.String? = builder.serverLaunchParameters
    /**
     * **This parameter is no longer used.** Server launch paths are now defined using the fleet's [RuntimeConfiguration](https://docs.aws.amazon.com/gamelift/latest/apireference/RuntimeConfiguration.html). Requests that use this parameter continue to be valid.
     */
    public val serverLaunchPath: kotlin.String? = builder.serverLaunchPath
    /**
     * Current status of the fleet. Possible fleet statuses include the following:
     * + NEW -- A new fleet resource has been defined and Amazon GameLift Servers has started creating the fleet. Desired instances is set to 1.
     * + DOWNLOADING/VALIDATING/BUILDING -- Amazon GameLift Servers is download the game server build, running install scripts, and then validating the build files. When complete, Amazon GameLift Servers launches a fleet instance.
     * + ACTIVATING -- Amazon GameLift Servers is launching a game server process and testing its connectivity with the Amazon GameLift Servers service.
     * + ACTIVE -- The fleet is now ready to host game sessions.
     * + ERROR -- An error occurred when downloading, validating, building, or activating the fleet.
     * + DELETING -- Hosts are responding to a delete fleet request.
     * + TERMINATED -- The fleet no longer exists.
     */
    public val status: aws.sdk.kotlin.services.gamelift.model.FleetStatus? = builder.status
    /**
     * A list of fleet activity that has been suspended using [StopFleetActions](https://docs.aws.amazon.com/gamelift/latest/apireference/API_StopFleetActions.html). This includes fleet auto-scaling. This attribute is used with fleets where `ComputeType` is `EC2`.
     */
    public val stoppedActions: List<FleetAction>? = builder.stoppedActions
    /**
     * A time stamp indicating when this data object was terminated. Format is a number expressed in Unix time as milliseconds (for example `"1469498468.057"`).
     */
    public val terminationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.terminationTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.FleetAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FleetAttributes(")
        append("anywhereConfiguration=$anywhereConfiguration,")
        append("buildArn=$buildArn,")
        append("buildId=$buildId,")
        append("certificateConfiguration=$certificateConfiguration,")
        append("computeType=$computeType,")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("fleetArn=$fleetArn,")
        append("fleetId=$fleetId,")
        append("fleetType=$fleetType,")
        append("instanceRoleArn=$instanceRoleArn,")
        append("instanceRoleCredentialsProvider=$instanceRoleCredentialsProvider,")
        append("instanceType=$instanceType,")
        append("logPaths=$logPaths,")
        append("metricGroups=$metricGroups,")
        append("name=$name,")
        append("newGameSessionProtectionPolicy=$newGameSessionProtectionPolicy,")
        append("operatingSystem=$operatingSystem,")
        append("resourceCreationLimitPolicy=$resourceCreationLimitPolicy,")
        append("scriptArn=$scriptArn,")
        append("scriptId=$scriptId,")
        append("serverLaunchParameters=$serverLaunchParameters,")
        append("serverLaunchPath=$serverLaunchPath,")
        append("status=$status,")
        append("stoppedActions=$stoppedActions,")
        append("terminationTime=$terminationTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = anywhereConfiguration?.hashCode() ?: 0
        result = 31 * result + (buildArn?.hashCode() ?: 0)
        result = 31 * result + (buildId?.hashCode() ?: 0)
        result = 31 * result + (certificateConfiguration?.hashCode() ?: 0)
        result = 31 * result + (computeType?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (fleetArn?.hashCode() ?: 0)
        result = 31 * result + (fleetId?.hashCode() ?: 0)
        result = 31 * result + (fleetType?.hashCode() ?: 0)
        result = 31 * result + (instanceRoleArn?.hashCode() ?: 0)
        result = 31 * result + (instanceRoleCredentialsProvider?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (logPaths?.hashCode() ?: 0)
        result = 31 * result + (metricGroups?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (newGameSessionProtectionPolicy?.hashCode() ?: 0)
        result = 31 * result + (operatingSystem?.hashCode() ?: 0)
        result = 31 * result + (resourceCreationLimitPolicy?.hashCode() ?: 0)
        result = 31 * result + (scriptArn?.hashCode() ?: 0)
        result = 31 * result + (scriptId?.hashCode() ?: 0)
        result = 31 * result + (serverLaunchParameters?.hashCode() ?: 0)
        result = 31 * result + (serverLaunchPath?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (stoppedActions?.hashCode() ?: 0)
        result = 31 * result + (terminationTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FleetAttributes

        if (anywhereConfiguration != other.anywhereConfiguration) return false
        if (buildArn != other.buildArn) return false
        if (buildId != other.buildId) return false
        if (certificateConfiguration != other.certificateConfiguration) return false
        if (computeType != other.computeType) return false
        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (fleetArn != other.fleetArn) return false
        if (fleetId != other.fleetId) return false
        if (fleetType != other.fleetType) return false
        if (instanceRoleArn != other.instanceRoleArn) return false
        if (instanceRoleCredentialsProvider != other.instanceRoleCredentialsProvider) return false
        if (instanceType != other.instanceType) return false
        if (logPaths != other.logPaths) return false
        if (metricGroups != other.metricGroups) return false
        if (name != other.name) return false
        if (newGameSessionProtectionPolicy != other.newGameSessionProtectionPolicy) return false
        if (operatingSystem != other.operatingSystem) return false
        if (resourceCreationLimitPolicy != other.resourceCreationLimitPolicy) return false
        if (scriptArn != other.scriptArn) return false
        if (scriptId != other.scriptId) return false
        if (serverLaunchParameters != other.serverLaunchParameters) return false
        if (serverLaunchPath != other.serverLaunchPath) return false
        if (status != other.status) return false
        if (stoppedActions != other.stoppedActions) return false
        if (terminationTime != other.terminationTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.FleetAttributes = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A set of attributes that are specific to an Anywhere fleet.
         */
        public var anywhereConfiguration: aws.sdk.kotlin.services.gamelift.model.AnywhereConfiguration? = null
        /**
         * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) associated with the Amazon GameLift Servers build resource that is deployed on instances in this fleet. In a GameLift build ARN, the resource ID matches the `BuildId` value. This attribute is used with fleets where `ComputeType` is "EC2".
         */
        public var buildArn: kotlin.String? = null
        /**
         * A unique identifier for the build resource that is deployed on instances in this fleet. This attribute is used with fleets where `ComputeType` is "EC2".
         */
        public var buildId: kotlin.String? = null
        /**
         * Determines whether a TLS/SSL certificate is generated for a fleet. This feature must be enabled when creating the fleet. All instances in a fleet share the same certificate.
         */
        public var certificateConfiguration: aws.sdk.kotlin.services.gamelift.model.CertificateConfiguration? = null
        /**
         * The type of compute resource used to host your game servers. You can use your own compute resources with Amazon GameLift Servers Anywhere or use Amazon EC2 instances with managed Amazon GameLift Servers.
         */
        public var computeType: aws.sdk.kotlin.services.gamelift.model.ComputeType? = null
        /**
         * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example `"1469498468.057"`).
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A human-readable description of the fleet.
         */
        public var description: kotlin.String? = null
        /**
         * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is assigned to a Amazon GameLift Servers fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is `arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912`. In a GameLift fleet ARN, the resource ID matches the `FleetId` value.
         */
        public var fleetArn: kotlin.String? = null
        /**
         * A unique identifier for the fleet.
         */
        public var fleetId: kotlin.String? = null
        /**
         * Indicates whether the fleet uses On-Demand or Spot instances. For more information, see [ On-Demand versus Spot Instances](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot). This fleet property can't be changed after the fleet is created.
         */
        public var fleetType: aws.sdk.kotlin.services.gamelift.model.FleetType? = null
        /**
         * A unique identifier for an IAM role that manages access to your Amazon Web Services services. With an instance role ARN set, any application that runs on an instance in this fleet can assume the role, including install scripts, server processes, and daemons (background processes). Create a role or look up a role's ARN by using the [IAM dashboard](https://console.aws.amazon.com/iam/) in the Amazon Web Services Management Console. Learn more about using on-box credentials for your game servers at [ Access external resources from a game server](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html). This attribute is used with fleets where `ComputeType` is `EC2`.
         */
        public var instanceRoleArn: kotlin.String? = null
        /**
         * Indicates that fleet instances maintain a shared credentials file for the IAM role defined in `InstanceRoleArn`. Shared credentials allow applications that are deployed with the game server executable to communicate with other Amazon Web Services resources. This property is used only when the game server is integrated with the server SDK version 5.x. For more information about using shared credentials, see [ Communicate with other Amazon Web Services resources from your fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html). This attribute is used with fleets where `ComputeType` is `EC2`.
         */
        public var instanceRoleCredentialsProvider: aws.sdk.kotlin.services.gamelift.model.InstanceRoleCredentialsProvider? = null
        /**
         * The Amazon EC2 instance type that the fleet uses. Instance type determines the computing resources of each instance in the fleet, including CPU, memory, storage, and networking capacity. See [Amazon Elastic Compute Cloud Instance Types](http://aws.amazon.com/ec2/instance-types/) for detailed descriptions. This attribute is used with fleets where `ComputeType` is `EC2`.
         */
        public var instanceType: aws.sdk.kotlin.services.gamelift.model.Ec2InstanceType? = null
        /**
         * **This parameter is no longer used.** Game session log paths are now defined using the Amazon GameLift Servers server API `ProcessReady()``logParameters`. See more information in the [Server API Reference](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process).
         */
        public var logPaths: List<String>? = null
        /**
         * Name of a metric group that metrics for this fleet are added to. In Amazon CloudWatch, you can view aggregated metrics for fleets that are in a metric group. A fleet can be included in only one metric group at a time. This attribute is used with fleets where `ComputeType` is `EC2`.
         */
        public var metricGroups: List<String>? = null
        /**
         * A descriptive label that is associated with a fleet. Fleet names do not need to be unique.
         */
        public var name: kotlin.String? = null
        /**
         * The type of game session protection to set on all new instances that are started in the fleet. This attribute is used with fleets where `ComputeType` is `EC2`.
         * + **NoProtection** -- The game session can be terminated during a scale-down event.
         * + **FullProtection** -- If the game session is in an `ACTIVE` status, it cannot be terminated during a scale-down event.
         */
        public var newGameSessionProtectionPolicy: aws.sdk.kotlin.services.gamelift.model.ProtectionPolicy? = null
        /**
         * The operating system of the fleet's computing resources. A fleet's operating system is determined by the OS of the build or script that is deployed on this fleet. This attribute is used with fleets where `ComputeType` is `EC2`.
         *
         * Amazon Linux 2 (AL2) will reach end of support on 6/30/2025. See more details in the [Amazon Linux 2 FAQs](http://aws.amazon.com/aws.amazon.com/amazon-linux-2/faqs/). For game servers that are hosted on AL2 and use server SDK version 4.x for Amazon GameLift Servers, first update the game server build to server SDK 5.x, and then deploy to AL2023 instances. See [ Migrate to server SDK version 5.](https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk5-migration.html)
         */
        public var operatingSystem: aws.sdk.kotlin.services.gamelift.model.OperatingSystem? = null
        /**
         * A policy that puts limits on the number of game sessions that a player can create within a specified span of time. With this policy, you can control players' ability to consume available resources.
         *
         * The policy is evaluated when a player tries to create a new game session. On receiving a `CreateGameSession` request, Amazon GameLift Servers checks that the player (identified by `CreatorId`) has created fewer than game session limit in the specified time period.
         */
        public var resourceCreationLimitPolicy: aws.sdk.kotlin.services.gamelift.model.ResourceCreationLimitPolicy? = null
        /**
         * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) associated with the GameLift script resource that is deployed on instances in this fleet. In a GameLift script ARN, the resource ID matches the `ScriptId` value.
         */
        public var scriptArn: kotlin.String? = null
        /**
         * A unique identifier for the Realtime script resource that is deployed on instances in this fleet. This attribute is used with fleets where `ComputeType` is "EC2".
         */
        public var scriptId: kotlin.String? = null
        /**
         * **This parameter is no longer used.** Server launch parameters are now defined using the fleet's runtime configuration. Requests that use this parameter continue to be valid.
         */
        public var serverLaunchParameters: kotlin.String? = null
        /**
         * **This parameter is no longer used.** Server launch paths are now defined using the fleet's [RuntimeConfiguration](https://docs.aws.amazon.com/gamelift/latest/apireference/RuntimeConfiguration.html). Requests that use this parameter continue to be valid.
         */
        public var serverLaunchPath: kotlin.String? = null
        /**
         * Current status of the fleet. Possible fleet statuses include the following:
         * + NEW -- A new fleet resource has been defined and Amazon GameLift Servers has started creating the fleet. Desired instances is set to 1.
         * + DOWNLOADING/VALIDATING/BUILDING -- Amazon GameLift Servers is download the game server build, running install scripts, and then validating the build files. When complete, Amazon GameLift Servers launches a fleet instance.
         * + ACTIVATING -- Amazon GameLift Servers is launching a game server process and testing its connectivity with the Amazon GameLift Servers service.
         * + ACTIVE -- The fleet is now ready to host game sessions.
         * + ERROR -- An error occurred when downloading, validating, building, or activating the fleet.
         * + DELETING -- Hosts are responding to a delete fleet request.
         * + TERMINATED -- The fleet no longer exists.
         */
        public var status: aws.sdk.kotlin.services.gamelift.model.FleetStatus? = null
        /**
         * A list of fleet activity that has been suspended using [StopFleetActions](https://docs.aws.amazon.com/gamelift/latest/apireference/API_StopFleetActions.html). This includes fleet auto-scaling. This attribute is used with fleets where `ComputeType` is `EC2`.
         */
        public var stoppedActions: List<FleetAction>? = null
        /**
         * A time stamp indicating when this data object was terminated. Format is a number expressed in Unix time as milliseconds (for example `"1469498468.057"`).
         */
        public var terminationTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.FleetAttributes) : this() {
            this.anywhereConfiguration = x.anywhereConfiguration
            this.buildArn = x.buildArn
            this.buildId = x.buildId
            this.certificateConfiguration = x.certificateConfiguration
            this.computeType = x.computeType
            this.creationTime = x.creationTime
            this.description = x.description
            this.fleetArn = x.fleetArn
            this.fleetId = x.fleetId
            this.fleetType = x.fleetType
            this.instanceRoleArn = x.instanceRoleArn
            this.instanceRoleCredentialsProvider = x.instanceRoleCredentialsProvider
            this.instanceType = x.instanceType
            this.logPaths = x.logPaths
            this.metricGroups = x.metricGroups
            this.name = x.name
            this.newGameSessionProtectionPolicy = x.newGameSessionProtectionPolicy
            this.operatingSystem = x.operatingSystem
            this.resourceCreationLimitPolicy = x.resourceCreationLimitPolicy
            this.scriptArn = x.scriptArn
            this.scriptId = x.scriptId
            this.serverLaunchParameters = x.serverLaunchParameters
            this.serverLaunchPath = x.serverLaunchPath
            this.status = x.status
            this.stoppedActions = x.stoppedActions
            this.terminationTime = x.terminationTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.FleetAttributes = FleetAttributes(this)

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.AnywhereConfiguration] inside the given [block]
         */
        public fun anywhereConfiguration(block: aws.sdk.kotlin.services.gamelift.model.AnywhereConfiguration.Builder.() -> kotlin.Unit) {
            this.anywhereConfiguration = aws.sdk.kotlin.services.gamelift.model.AnywhereConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.CertificateConfiguration] inside the given [block]
         */
        public fun certificateConfiguration(block: aws.sdk.kotlin.services.gamelift.model.CertificateConfiguration.Builder.() -> kotlin.Unit) {
            this.certificateConfiguration = aws.sdk.kotlin.services.gamelift.model.CertificateConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.ResourceCreationLimitPolicy] inside the given [block]
         */
        public fun resourceCreationLimitPolicy(block: aws.sdk.kotlin.services.gamelift.model.ResourceCreationLimitPolicy.Builder.() -> kotlin.Unit) {
            this.resourceCreationLimitPolicy = aws.sdk.kotlin.services.gamelift.model.ResourceCreationLimitPolicy.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
