// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Resource capacity settings. Fleet capacity is measured in Amazon EC2 instances. Pending and terminating counts are non-zero when the fleet capacity is adjusting to a scaling event or if access to resources is temporarily affected.
 */
public class Ec2InstanceCounts private constructor(builder: Builder) {
    /**
     * Actual number of instances that are ready to host game sessions.
     */
    public val active: kotlin.Int? = builder.active
    /**
     * Requested number of active instances. Amazon GameLift Servers takes action as needed to maintain the desired number of instances. Capacity is scaled up or down by changing the desired instances. A change in the desired instances value can take up to 1 minute to be reflected when viewing a fleet's capacity settings.
     */
    public val desired: kotlin.Int? = builder.desired
    /**
     * Number of active instances that are not currently hosting a game session.
     */
    public val idle: kotlin.Int? = builder.idle
    /**
     * The maximum instance count value allowed.
     */
    public val maximum: kotlin.Int? = builder.maximum
    /**
     * The minimum instance count value allowed.
     */
    public val minimum: kotlin.Int? = builder.minimum
    /**
     * Number of instances that are starting but not yet active.
     */
    public val pending: kotlin.Int? = builder.pending
    /**
     * Number of instances that are no longer active but haven't yet been terminated.
     */
    public val terminating: kotlin.Int? = builder.terminating

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.Ec2InstanceCounts = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Ec2InstanceCounts(")
        append("active=$active,")
        append("desired=$desired,")
        append("idle=$idle,")
        append("maximum=$maximum,")
        append("minimum=$minimum,")
        append("pending=$pending,")
        append("terminating=$terminating")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = active ?: 0
        result = 31 * result + (desired ?: 0)
        result = 31 * result + (idle ?: 0)
        result = 31 * result + (maximum ?: 0)
        result = 31 * result + (minimum ?: 0)
        result = 31 * result + (pending ?: 0)
        result = 31 * result + (terminating ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Ec2InstanceCounts

        if (active != other.active) return false
        if (desired != other.desired) return false
        if (idle != other.idle) return false
        if (maximum != other.maximum) return false
        if (minimum != other.minimum) return false
        if (pending != other.pending) return false
        if (terminating != other.terminating) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.Ec2InstanceCounts = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Actual number of instances that are ready to host game sessions.
         */
        public var active: kotlin.Int? = null
        /**
         * Requested number of active instances. Amazon GameLift Servers takes action as needed to maintain the desired number of instances. Capacity is scaled up or down by changing the desired instances. A change in the desired instances value can take up to 1 minute to be reflected when viewing a fleet's capacity settings.
         */
        public var desired: kotlin.Int? = null
        /**
         * Number of active instances that are not currently hosting a game session.
         */
        public var idle: kotlin.Int? = null
        /**
         * The maximum instance count value allowed.
         */
        public var maximum: kotlin.Int? = null
        /**
         * The minimum instance count value allowed.
         */
        public var minimum: kotlin.Int? = null
        /**
         * Number of instances that are starting but not yet active.
         */
        public var pending: kotlin.Int? = null
        /**
         * Number of instances that are no longer active but haven't yet been terminated.
         */
        public var terminating: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.Ec2InstanceCounts) : this() {
            this.active = x.active
            this.desired = x.desired
            this.idle = x.idle
            this.maximum = x.maximum
            this.minimum = x.minimum
            this.pending = x.pending
            this.terminating = x.terminating
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.Ec2InstanceCounts = Ec2InstanceCounts(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
